/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.io.File;
import java.io.IOException;
import javax.crypto.Cipher;
import junit.framework.TestCase;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Node;
import net.smartlab.config.XMLConfiguration;

public class XMLConfigurationTest
extends TestCase {
    private XMLConfiguration config;
    private Cipher cipher;
    private String filename = "res/test.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.config = new XMLConfiguration(this.filename);
        this.cipher = null;
    }

    public void testIsChanged() throws ConfigurationException, IOException {
        TestCase.assertFalse((boolean)this.config.isChanged());
        File file = new File(this.filename);
        System.gc();
        file.setLastModified(System.currentTimeMillis());
        TestCase.assertTrue((boolean)this.config.isChanged());
    }

    public void testUpdate() throws ConfigurationException {
        Object[] children = this.config.children.toArray();
        TestCase.assertSame((Object)children, (Object)this.config.children.toArray());
        File file = new File(this.filename);
        System.gc();
        file.setLastModified(System.currentTimeMillis());
        this.config.update();
        TestCase.assertNotSame((Object)children, (Object)this.config.children.toArray());
    }

    public void testXMLConfigurationFile() throws Exception {
        new XMLConfiguration(new File(this.filename));
    }

    public void testXMLConfigurationString() throws Exception {
        new XMLConfiguration(this.filename);
    }

    public void testXMLConfigurationURL() throws Exception {
        new XMLConfiguration(new File(this.filename).toURL());
    }

    public void testXMLConfigurationFileCipher() throws Exception {
        new XMLConfiguration(new File(this.filename), null);
        new XMLConfiguration(new File(this.filename), this.cipher);
    }

    public void testXMLConfigurationStringCipher() throws Exception {
        new XMLConfiguration(this.filename, null);
        new XMLConfiguration(this.filename, this.cipher);
    }

    public void testXMLConfigurationURLCipher() throws Exception {
        new XMLConfiguration(new File(this.filename).toURL(), null);
        new XMLConfiguration(new File(this.filename).toURL(), this.cipher);
    }

    public void testResolveStringString() throws Exception {
        Node node = this.config.resolve("something", "first");
        TestCase.assertEquals((String)"first ref", (String)node.getContent());
        try {
            this.config.resolve("someother", "second");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testSetResolve() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetResolve() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetInstance() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetId() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetElements() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetElementsString() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetElementStringStringString() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetAttributeNames() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetAttribute() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetContent() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testResolve() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testNode() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testElement() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetName() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetElementString() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetElementStringString() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testGetAttributeValues() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }

    public void testToString() {
        XMLConfigurationTest.fail((String)"Not yet implemented");
    }
}

