/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.xml.parsers.SAXParserFactory;
import net.smartlab.config.Configuration;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.config.Node;
import net.smartlab.config.Reference;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLConfiguration
extends Configuration {
    private long access;
    private URL source;
    private Cipher cipher;

    public XMLConfiguration(File source) throws ConfigurationException {
        try {
            this.source = source.toURL();
        }
        catch (MalformedURLException murle) {
            throw new ConfigurationException(murle);
        }
        this.update();
    }

    public XMLConfiguration(String source) throws ConfigurationException {
        this(new File(source));
    }

    public XMLConfiguration(URL source) throws ConfigurationException {
        this.source = source;
        this.update();
    }

    public XMLConfiguration(File source, Cipher cipher) throws ConfigurationException {
        this(source);
        this.cipher = cipher;
    }

    public XMLConfiguration(String source, Cipher cipher) throws ConfigurationException {
        this(source);
        this.cipher = cipher;
    }

    public XMLConfiguration(URL source, Cipher cipher) throws ConfigurationException {
        this(source);
        this.cipher = cipher;
    }

    public boolean isChanged() throws ConfigurationException {
        try {
            return this.source.openConnection().getLastModified() > this.access;
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe);
        }
    }

    public void update() throws ConfigurationException {
        try {
            this.access = System.currentTimeMillis();
            this.parent = null;
            this.children.clear();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (this.cipher != null) {
                factory.setValidating(true);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                factory.newSAXParser().parse((InputStream)new CipherInputStream(this.source.openStream(), this.cipher), (DefaultHandler)new XMLHandler(this));
            } else {
                factory.setValidating(true);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                factory.newSAXParser().parse(this.source.openStream(), (DefaultHandler)new XMLHandler(this));
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected static class XMLHandler
    extends DefaultHandler {
        protected Element owner;
        protected Locator locator;
        protected XMLReader reader;

        public XMLHandler(Configuration owner) {
            this.owner = owner;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String namespace, String prefix, String name, Attributes attributes) {
            if (this.owner instanceof Node) {
                if (this.owner instanceof Configuration && this.owner.parent == null) {
                    ((Configuration)this.owner).init(name, attributes);
                } else {
                    Element child = null;
                    child = attributes.getIndex("refid") > -1 ? new Reference((Node)this.owner, name, attributes.getValue("refid")) : new Node((Node)this.owner, name, attributes);
                    ((Node)this.owner).children.add(child);
                    this.owner = child;
                }
            } else {
                throw new RuntimeException("Reference elements cannot have a body");
            }
        }

        public void characters(char[] chars, int start, int length) {
            if (!(this.owner instanceof Node)) {
                throw new RuntimeException("Non node elements cannot have a body");
            }
            ((Node)this.owner).content = new String(chars, start, length);
        }

        public void endElement(String namespace, String prefix, String name) {
            this.owner = this.owner.parent;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            try {
                InputSource source = super.resolveEntity(publicId, systemId);
                if (source == null) {
                    return new InputSource(new StringReader(""));
                }
                return source;
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        }
    }
}

