/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import net.smartlab.config.Configuration;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.config.Node;
import net.smartlab.config.Reference;

public final class SQLConfiguration
extends Configuration {
    private DataSource pool;
    private long updated;
    private static final String LAST_UPDATE = "'smartconfig_last_update'";

    public SQLConfiguration(Connection connection) throws ConfigurationException {
        this(new SimpleDataSource(connection));
    }

    public SQLConfiguration(DataSource pool) throws ConfigurationException {
        this.pool = pool;
        this.update();
    }

    public boolean isChanged() throws ConfigurationException {
        return this.getLastUpdate(false) > this.updated;
    }

    public void update() throws ConfigurationException {
        Connection connection = null;
        try {
            connection = this.pool.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT name, value FROM config WHERE name <> 'smartconfig_last_update'");
            ResultSet rows = statement.executeQuery();
            while (rows.next()) {
                String name = rows.getString(1);
                String value = rows.getString(2);
                this.add(name, value);
            }
            this.updated = this.getLastUpdate(true);
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLastUpdate(boolean set) throws ConfigurationException {
        Connection connection = null;
        try {
            connection = this.pool.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT value FROM config WHERE name = 'smartconfig_last_update'");
            ResultSet rows = statement.executeQuery();
            if (rows.next()) {
                long l = Long.parseLong(rows.getString(1));
                return l;
            }
            if (set) {
                long time = System.currentTimeMillis();
                this.setLastUpdate(time);
                long l = time;
                return l;
            }
            throw new ConfigurationException("Cannot find special configuration parameter 'smartconfig_last_update'");
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    public void setLastUpdate(long timestamp) throws ConfigurationException {
        Connection connection = null;
        try {
            connection = this.pool.getConnection();
            connection.prepareStatement("INSERT INTO config (name, value) VALUES ('smartconfig_last_update', '" + timestamp + "')").execute();
        }
        catch (SQLException sqle) {
            throw new ConfigurationException(sqle);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    private Element add(String fqn, String value) throws ConfigurationException {
        String path = null;
        String name = fqn;
        int index = -1;
        String attribute = null;
        int pathLength = fqn.lastIndexOf(".");
        int itemSeparator = fqn.indexOf("#");
        int attributeStart = fqn.indexOf("[");
        if (pathLength > -1) {
            path = fqn.substring(0, pathLength);
            name = fqn.substring(pathLength + 1);
        }
        if (itemSeparator > -1) {
            if (attributeStart > -1) {
                name = fqn.substring(pathLength + 1, itemSeparator);
                index = Integer.parseInt(fqn.substring(itemSeparator + 1, attributeStart));
                attribute = fqn.substring(attributeStart + 1, fqn.length() - 1);
            } else {
                name = fqn.substring(pathLength + 1, itemSeparator);
                index = Integer.parseInt(fqn.substring(itemSeparator + 1));
            }
        } else if (attributeStart > -1) {
            name = fqn.substring(pathLength + 1, attributeStart);
            attribute = fqn.substring(attributeStart + 1, fqn.length() - 1);
        }
        Node parent = null;
        Element node = null;
        if (path != null) {
            parent = this.findNode(this, path);
            if (parent == null) {
                parent = (Node)this.add(path, null);
            }
            if (index > -1) {
                try {
                    node = (Element)parent.getElements(name).toArray()[index - 1];
                }
                catch (Exception e) {
                    node = null;
                }
            } else {
                node = parent.getElement(name);
            }
        } else if (this.name == null || this.name.equals(name)) {
            node = this;
            node.name = name;
        } else {
            throw new ConfigurationException("Configuration tree can have only one root node: found " + name + " conflicting with " + this.name);
        }
        if (node == null) {
            node = new Node(parent, name, null);
            if (index > -1) {
                try {
                    parent.children.set(index - 1, node);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    parent.children.add(index - 1, node);
                }
            } else {
                parent.children.add(node);
            }
        }
        if (attribute == null) {
            if (value != null && value.trim().length() > 0) {
                ((Node)node).content = value;
            }
        } else if (attribute.equals("refid")) {
            node = new Reference(parent, name, value);
        } else {
            ((Node)node).attributes.put(attribute, value);
        }
        return node;
    }

    private Node findNode(Node node, String path) throws ConfigurationException {
        if (node instanceof SQLConfiguration && path.startsWith(node.name + '.')) {
            path = path.substring(path.indexOf(46) + 1);
        }
        if (node == null || path.equals(node.name)) {
            return node;
        }
        int index = path.indexOf(46);
        if (index > -1) {
            String child = path.substring(0, index);
            return this.findNode((Node)node.getElement(child), path.substring(index + 1));
        }
        return (Node)node.getElement(path);
    }

    private static class SimpleDataSource
    implements DataSource {
        private Connection connection;

        public SimpleDataSource(Connection connection) {
            this.connection = new ConnectionWrapper(connection);
        }

        public Connection getConnection() throws SQLException {
            return this.connection;
        }

        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException();
        }

        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        private static class ConnectionWrapper
        implements Connection {
            private Connection connection;

            public ConnectionWrapper(Connection connection) {
                this.connection = connection;
            }

            public void clearWarnings() throws SQLException {
                this.connection.clearWarnings();
            }

            public void close() throws SQLException {
            }

            public void commit() throws SQLException {
                this.connection.commit();
            }

            public Statement createStatement() throws SQLException {
                return this.connection.createStatement();
            }

            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                return this.connection.createStatement(resultSetType, resultSetConcurrency);
            }

            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            public boolean getAutoCommit() throws SQLException {
                return this.connection.getAutoCommit();
            }

            public String getCatalog() throws SQLException {
                return this.connection.getCatalog();
            }

            public int getHoldability() throws SQLException {
                return this.connection.getHoldability();
            }

            public DatabaseMetaData getMetaData() throws SQLException {
                return this.connection.getMetaData();
            }

            public int getTransactionIsolation() throws SQLException {
                return this.connection.getTransactionIsolation();
            }

            public Map getTypeMap() throws SQLException {
                return this.connection.getTypeMap();
            }

            public SQLWarning getWarnings() throws SQLException {
                return this.connection.getWarnings();
            }

            public boolean isClosed() throws SQLException {
                return this.connection.isClosed();
            }

            public boolean isReadOnly() throws SQLException {
                return this.connection.isReadOnly();
            }

            public String nativeSQL(String sql) throws SQLException {
                return this.connection.nativeSQL(sql);
            }

            public CallableStatement prepareCall(String sql) throws SQLException {
                return this.connection.prepareCall(sql);
            }

            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
            }

            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                return this.connection.prepareStatement(sql);
            }

            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                return this.connection.prepareStatement(sql, autoGeneratedKeys);
            }

            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                return this.connection.prepareStatement(sql, columnIndexes);
            }

            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                return this.connection.prepareStatement(sql, columnNames);
            }

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }

            public void releaseSavepoint(Savepoint savepoint) throws SQLException {
                this.connection.releaseSavepoint(savepoint);
            }

            public void rollback() throws SQLException {
                this.connection.rollback();
            }

            public void rollback(Savepoint savepoint) throws SQLException {
                this.connection.rollback(savepoint);
            }

            public void setAutoCommit(boolean autoCommit) throws SQLException {
                this.connection.setAutoCommit(autoCommit);
            }

            public void setCatalog(String catalog) throws SQLException {
                this.connection.setCatalog(catalog);
            }

            public void setHoldability(int holdability) throws SQLException {
                this.connection.setHoldability(holdability);
            }

            public void setReadOnly(boolean readOnly) throws SQLException {
                this.connection.setReadOnly(readOnly);
            }

            public Savepoint setSavepoint() throws SQLException {
                return this.connection.setSavepoint();
            }

            public Savepoint setSavepoint(String name) throws SQLException {
                return this.connection.setSavepoint(name);
            }

            public void setTransactionIsolation(int level) throws SQLException {
                this.connection.setTransactionIsolation(level);
            }

            public void setTypeMap(Map typeMap) throws SQLException {
                this.connection.setTypeMap(typeMap);
            }
        }
    }
}

