/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.util.Collection;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.config.Node;

public class Reference
extends Element {
    protected static final String REFERENCE = "refid";
    protected static final String IDENTIFIER = "id";
    protected Node node;
    protected String id;

    protected Reference(Node parent, String name, String id) {
        super(parent, name);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Collection getElements() throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(this.name, this.id);
        }
        try {
            return this.node.getElements();
        }
        catch (NullPointerException npe) {
            throw new ConfigurationException("Undefined reference to node " + this.id);
        }
    }

    public Collection getElements(String name) throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(name, this.id);
        }
        try {
            return this.node.getElements(name);
        }
        catch (NullPointerException npe) {
            throw new ConfigurationException("Undefined reference to node " + this.id);
        }
    }

    public Element getElement(String name, String attribute, String value) throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(name, this.id);
        }
        try {
            return this.node.getElement(name, attribute, value);
        }
        catch (NullPointerException npe) {
            throw new ConfigurationException("Undefined reference to node " + this.id);
        }
    }

    public Collection getAttributeNames() throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(this.name, this.id);
        }
        try {
            return this.node.getAttributeNames();
        }
        catch (NullPointerException npe) {
            throw new ConfigurationException("Undefined reference to node " + this.id);
        }
    }

    public String getAttribute(String name) throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(name, this.id);
        }
        try {
            return this.node.getAttribute(name);
        }
        catch (NullPointerException npe) {
            throw new ConfigurationException("Undefined reference to node " + this.id);
        }
    }

    public String getContent() throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(this.name, this.id);
        }
        try {
            return this.node.content;
        }
        catch (NullPointerException npe) {
            throw new ConfigurationException("Undefined reference to node " + this.id);
        }
    }

    public void resolve() throws ConfigurationException {
        if (this.node == null) {
            this.node = this.parent.resolve(this.name, this.id);
        }
    }
}

