/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import org.xml.sax.Attributes;

public class Node
extends Element {
    protected List children;
    protected Map attributes = new HashMap();
    protected String content;
    protected boolean resolved;

    protected Node(Node parent, String name, Attributes attributes) {
        super(parent, name);
        this.children = new ArrayList();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.attributes.put(attributes.getQName(i), attributes.getValue(i));
            }
        }
    }

    public String getId() {
        return (String)this.attributes.get("id");
    }

    public Collection getElements() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Collection getElements(String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        Iterator children = this.children.iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!name.equals(child.getName())) continue;
            result.add(child);
        }
        return Collections.unmodifiableCollection(result);
    }

    public Element getElement(String name, String attribute, String value) throws ConfigurationException {
        Iterator children = this.children.iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!name.equals(child.name)) continue;
            if (attribute != null) {
                String found = child.getAttribute(attribute);
                if (found == null) continue;
                if (value != null) {
                    if (!value.equals(found)) continue;
                    return child;
                }
                return child;
            }
            return child;
        }
        return null;
    }

    public Collection getAttributeNames() {
        return Collections.unmodifiableCollection(this.attributes.entrySet());
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public String getContent() {
        return this.content;
    }

    public void resolve() throws ConfigurationException {
        if (!this.resolved) {
            Iterator elements = this.children.iterator();
            while (elements.hasNext()) {
                ((Element)elements.next()).resolve();
            }
            this.resolved = true;
        }
    }

    protected Node resolve(String name, String id) throws ConfigurationException {
        Iterator children = this.children.iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!(child instanceof Node) || !name.equals(child.name) || !id.equals(child.getId())) continue;
            return (Node)child;
        }
        return this.parent.resolve(name, id);
    }
}

