/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.config.Listener;
import net.smartlab.config.Node;
import net.smartlab.config.SQLConfiguration;
import net.smartlab.config.XMLConfiguration;
import org.xml.sax.Attributes;

public abstract class Configuration
extends Node {
    private boolean resolve;
    private Collection listeners = new ArrayList();

    protected Configuration() {
        super(null, null, null);
    }

    protected void init(String name, Attributes attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes = new HashMap(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.attributes.put(attributes.getQName(i), attributes.getValue(i));
            }
        }
        this.parent = this;
    }

    protected Node resolve(String name, String id) throws ConfigurationException {
        Iterator children = this.children.iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!(child instanceof Node) || !name.equals(child.name) || !id.equals(child.getId())) continue;
            return (Node)child;
        }
        throw new ConfigurationException("Cannot resolve element " + name + " with id " + id);
    }

    public abstract boolean isChanged() throws ConfigurationException;

    public abstract void update() throws ConfigurationException;

    public void setResolve(boolean resolve) {
        this.resolve = resolve;
    }

    public boolean getResolve() {
        return this.resolve;
    }

    public void setListeners(Collection listeners) {
        this.listeners = listeners;
    }

    public Collection getListeners() {
        return this.listeners;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static final Configuration getInstance(String uri) throws ConfigurationException, URISyntaxException {
        return Configuration.getInstance(new URI(uri), (Collection)null);
    }

    public static final Configuration getInstance(String uri, Listener listener) throws ConfigurationException, URISyntaxException {
        return Configuration.getInstance(new URI(uri), Collections.singletonList(listener));
    }

    public static final Configuration getInstance(String uri, Collection listeners) throws ConfigurationException, URISyntaxException {
        return Configuration.getInstance(new URI(uri), listeners);
    }

    public static final Configuration getInstance(URI uri) throws ConfigurationException {
        return Configuration.getInstance(uri, (Collection)null);
    }

    public static final Configuration getInstance(URI uri, Listener listener) throws ConfigurationException {
        return Configuration.getInstance(uri, Collections.singletonList(listener));
    }

    public static final Configuration getInstance(URI uri, Collection listeners) throws ConfigurationException {
        Configuration result = null;
        if (uri.getScheme().equals("jdbc")) {
            try {
                result = new SQLConfiguration(DriverManager.getConnection(uri.getPath()));
            }
            catch (SQLException sqle) {
                throw new ConfigurationException(sqle);
            }
        } else {
            if (uri.getScheme().equals("jndi")) {
                throw new ConfigurationException("Not yet supported scheme " + uri.getScheme());
            }
            if (uri.getScheme().equals("file")) {
                result = new XMLConfiguration(uri.getPath());
            } else {
                throw new ConfigurationException("No available handler for " + uri.getScheme());
            }
        }
        if (listeners != null) {
            result.listeners.addAll(listeners);
        }
        SQLConfiguration sQLConfiguration = result;
        sQLConfiguration.getClass();
        sQLConfiguration.new Monitor().start();
        return result;
    }

    private class Monitor
    extends Thread {
        private long sleep = Long.parseLong(System.getProperty("smartconfig.monitor.delay", "60000"));

        private Monitor() {
        }

        public void run() {
            while (true) {
                block8: {
                    if (!Configuration.this.listeners.isEmpty()) {
                        try {
                            if (!Configuration.this.isChanged()) break block8;
                            Configuration.this.update();
                            Iterator notifications = Configuration.this.listeners.iterator();
                            while (notifications.hasNext()) {
                                ((Listener)notifications.next()).onUpdate(Configuration.this);
                            }
                        }
                        catch (ConfigurationException ce) {
                            Iterator notifications = Configuration.this.listeners.iterator();
                            while (notifications.hasNext()) {
                                ce.printStackTrace();
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

