/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Node;

public abstract class Element {
    protected Node parent;
    protected String name;

    protected Element(Node parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getId();

    public abstract Collection getElements() throws ConfigurationException;

    public abstract Collection getElements(String var1) throws ConfigurationException;

    public Element getElement(String name) throws ConfigurationException {
        return this.getElement(name, null, null);
    }

    public Element getElement(String name, String attribute) throws ConfigurationException {
        return this.getElement(name, attribute, null);
    }

    public abstract Element getElement(String var1, String var2, String var3) throws ConfigurationException;

    public abstract Collection getAttributeNames() throws ConfigurationException;

    public abstract String getAttribute(String var1) throws ConfigurationException;

    public Collection getAttributeValues(String name) throws ConfigurationException {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.getAttribute(name), ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public abstract String getContent() throws ConfigurationException;

    public abstract void resolve() throws ConfigurationException;

    public String toString() {
        try {
            StringBuffer result = new StringBuffer();
            result.append('<');
            result.append(this.name);
            Iterator attributes = this.getAttributeNames().iterator();
            while (attributes.hasNext()) {
                String name = (String)attributes.next();
                result.append(' ');
                result.append(name);
                result.append("='");
                result.append(this.getAttribute(name));
                result.append("'");
            }
            result.append(">\n");
            result.append(this.getContent());
            Iterator elements = this.getElements().iterator();
            while (elements.hasNext()) {
                result.append(elements.next().toString());
            }
            result.append("</");
            result.append(this.name);
            result.append(">\n");
            return result.toString();
        }
        catch (ConfigurationException ce) {
            return ce.toString();
        }
    }
}

