/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.config;

import java.util.HashMap;
import java.util.Iterator;
import net.smartlab.config.ConfigurationException;
import net.smartlab.config.Element;
import net.smartlab.config.Node;
import org.xml.sax.Attributes;

public abstract class Configuration
extends Node {
    private boolean resolve;

    protected Configuration() {
        super(null, null, null);
    }

    protected void init(String name, Attributes attributes) {
        this.name = name;
        if (attributes != null) {
            this.attributes = new HashMap(attributes.getLength());
            int i = 0;
            while (i < attributes.getLength()) {
                this.attributes.put(attributes.getQName(i), attributes.getValue(i));
                ++i;
            }
        }
        this.parent = this;
    }

    protected Node resolve(String name, String id) throws ConfigurationException {
        Iterator children = this.children.iterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!(child instanceof Node) || !name.equals(child.name) || !id.equals(child.getId())) continue;
            return (Node)child;
        }
        throw new ConfigurationException("Cannot resolve element " + name + " with id " + id);
    }

    public abstract boolean isChanged() throws ConfigurationException;

    public abstract void update() throws ConfigurationException;

    public void setResolve(boolean resolve) {
        this.resolve = resolve;
    }

    public boolean getResolve() {
        return this.resolve;
    }
}

