/* LICENSE */

package net.smartlab.config;

import java.util.Collection;

/**
 * @testcase net.smartlab.config.test.TestReference 
 */
public class Reference extends Element {
	/**
	 * The name of the element attribute defining a reference to another element. 
	 */
	protected final static String REFERENCE = "refid";
	/**
	 * The name of the element attribute defining a valid reference target.
	 */
	protected final static String IDENTIFIER = "id";
	/**
	 * The referenced node.
	 * It will be <code>null</code> until resolved.
	 */
	protected Node node;
	/**
	 * The unique identifier for this reference.
	 */
	protected String id;

	/**
	 * Creates a reference contained by the given parent node with a specified name and unique identifier.
	 * @param parent the node containing the element.
	 * @param name the element name.
	 * @param id the element identifier.
	 */
	protected Reference(Node parent, String name, String id) {
		super(parent, name);
		this.id = id;
	}

	/**
	 * @see net.smartlab.config.Element#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * @see net.smartlab.config.Element#getElements()
	 */
	public Collection getElements() throws ConfigurationException {
		if (node == null) {
			parent.resolve(name, id);
		}
		return node.getElements();
	}

	/**
	 * @see net.smartlab.config.Element#getElements(java.lang.String)
	 */
	public Collection getElements(String name) throws ConfigurationException {
		if (node == null) {
			parent.resolve(name, id);
		}
		return node.getElements(name);
	}

	/**
	 * @see net.smartlab.config.Element#getElement(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Element getElement(String name, String attribute, String value) throws ConfigurationException {
		if (node == null) {
			parent.resolve(name, id);
		}
		return node.getElement(name, attribute, value);
	}

	/**
	 * @see net.smartlab.config.Element#getAttributeNames()
	 */
	public Collection getAttributeNames() throws ConfigurationException {
		if (node == null) {
			parent.resolve(name, id);
		}
		return node.getAttributeNames();
	}

	/**
	 * @see net.smartlab.config.Element#getAttribute(java.lang.String)
	 */
	public String getAttribute(String name) throws ConfigurationException {
		if (node == null) {
			parent.resolve(name, id);
		}
		return node.getAttribute(name);
	}

	/**
	 * @see net.smartlab.config.Element#getContent()
	 */
	public String getContent() throws ConfigurationException {
		if (node == null) {
			parent.resolve(name, id);
		}
		return node.content;
	}

	/**
	 * @see net.smartlab.config.Element#resolve()
	 */
	public void resolve() throws ConfigurationException {
		if (node == null) {
			node = parent.resolve(name, id);
		}
	}
}

