/* LICENSE */

package net.smartlab.config;

/**
 * Thrown to indicate the configuration tree scanning or querying has failed.
 * Possibile reasons are dependant by the concrete configuration implementation.
 *
 * @author rlogiacco@smartlab.net
 */
public class ConfigurationException extends Exception {

	private static final long serialVersionUID = 3921809995320346461L;

    /**
	 * Instantiates the class.
	 */
	public ConfigurationException() {
		super();
	}

	/**
	 * Instantiates the class with a message.
	 *
	 * @param message a description of the exception.
	 */
	public ConfigurationException(String message) {
		super(message);
	}

	/**
	 * Instantiates the class with a cause.
	 *
	 * @param cause the originating cause.
	 */
	public ConfigurationException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates the class with a message and cause.
	 *
	 * @param message a description of the exception.
	 * @param cause the originating cause.
	 */
	public ConfigurationException(String message, Throwable cause) {
		super(message, cause);
	}
}
