/**
 * Backpack for Android - Skyscanner's Design System
 *
 * Copyright 2018 Skyscanner Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated: do not edit
@file:Suppress("RedundantVisibilityModifier", "unused")

package net.skyscanner.backpack.compose.tokens

import androidx.compose.ui.graphics.Color
import kotlin.Boolean

public class BpkColors private constructor(
    public val isLight: Boolean,
    public val canvas: Color,
    public val canvasContrast: Color,
    public val coreAccent: Color,
    public val coreEco: Color,
    public val corePrimary: Color,
    public val line: Color,
    public val lineOnDark: Color,
    public val overlay: Color,
    public val scrim: Color,
    public val statusDangerFill: Color,
    public val statusDangerSpot: Color,
    public val statusSuccessFill: Color,
    public val statusSuccessSpot: Color,
    public val statusWarningFill: Color,
    public val statusWarningSpot: Color,
    public val surfaceContrast: Color,
    public val surfaceDefault: Color,
    public val surfaceElevated: Color,
    public val surfaceHero: Color,
    public val surfaceHighlight: Color,
    public val surfaceLowContrast: Color,
    public val surfaceSubtle: Color,
    public val textDisabled: Color,
    public val textDisabledOnDark: Color,
    public val textError: Color,
    public val textHero: Color,
    public val textLink: Color,
    public val textOnDark: Color,
    public val textOnLight: Color,
    public val textPrimary: Color,
    public val textPrimaryInverse: Color,
    public val textSecondary: Color,
) {
    internal companion object {
        public fun light(
            canvas: Color = Color(0xFFFFFFFF),
            canvasContrast: Color = Color(0xFFEFF3F8),
            coreAccent: Color = Color(0xFF0062E3),
            coreEco: Color = Color(0xFF0FA1A9),
            corePrimary: Color = Color(0xFF05203C),
            line: Color = Color(0xFFC1C7CF),
            lineOnDark: Color = Color(0x80FFFFFF),
            overlay: Color = Color(0x33000000),
            scrim: Color = Color(0xB3000000),
            statusDangerFill: Color = Color(0xFFFFE9F9),
            statusDangerSpot: Color = Color(0xFFE70866),
            statusSuccessFill: Color = Color(0xFFD4FFF2),
            statusSuccessSpot: Color = Color(0xFF0C838A),
            statusWarningFill: Color = Color(0xFFFFF7CF),
            statusWarningSpot: Color = Color(0xFFF55D42),
            surfaceContrast: Color = Color(0xFF05203C),
            surfaceDefault: Color = Color(0xFFFFFFFF),
            surfaceElevated: Color = Color(0xFFFFFFFF),
            surfaceHero: Color = Color(0xFF0062E3),
            surfaceHighlight: Color = Color(0xFFE0E4E9),
            surfaceLowContrast: Color = Color(0xFFF7F9FB),
            surfaceSubtle: Color = Color(0xFFE3F0FF),
            textDisabled: Color = Color(0x33000000),
            textDisabledOnDark: Color = Color(0x80FFFFFF),
            textError: Color = Color(0xFFE70866),
            textHero: Color = Color(0xFF0062E3),
            textLink: Color = Color(0xFF0062E3),
            textOnDark: Color = Color(0xFFFFFFFF),
            textOnLight: Color = Color(0xFF161616),
            textPrimary: Color = Color(0xFF161616),
            textPrimaryInverse: Color = Color(0xFFFFFFFF),
            textSecondary: Color = Color(0xFF626971),
        ): BpkColors = BpkColors(
            isLight = true,
            canvas = canvas,
            canvasContrast = canvasContrast,
            coreAccent = coreAccent,
            coreEco = coreEco,
            corePrimary = corePrimary,
            line = line,
            lineOnDark = lineOnDark,
            overlay = overlay,
            scrim = scrim,
            statusDangerFill = statusDangerFill,
            statusDangerSpot = statusDangerSpot,
            statusSuccessFill = statusSuccessFill,
            statusSuccessSpot = statusSuccessSpot,
            statusWarningFill = statusWarningFill,
            statusWarningSpot = statusWarningSpot,
            surfaceContrast = surfaceContrast,
            surfaceDefault = surfaceDefault,
            surfaceElevated = surfaceElevated,
            surfaceHero = surfaceHero,
            surfaceHighlight = surfaceHighlight,
            surfaceLowContrast = surfaceLowContrast,
            surfaceSubtle = surfaceSubtle,
            textDisabled = textDisabled,
            textDisabledOnDark = textDisabledOnDark,
            textError = textError,
            textHero = textHero,
            textLink = textLink,
            textOnDark = textOnDark,
            textOnLight = textOnLight,
            textPrimary = textPrimary,
            textPrimaryInverse = textPrimaryInverse,
            textSecondary = textSecondary,
        )

        public fun dark(
            canvas: Color = Color(0xFF010913),
            canvasContrast: Color = Color(0xFF010913),
            coreAccent: Color = Color(0xFF84E9FF),
            coreEco: Color = Color(0xFF0FA1A9),
            corePrimary: Color = Color(0xFF054184),
            line: Color = Color(0xFF44505F),
            lineOnDark: Color = Color(0xFF44505F),
            overlay: Color = Color(0xCCFFFFFF),
            scrim: Color = Color(0xB3000000),
            statusDangerFill: Color = Color(0xFFFFCADD),
            statusDangerSpot: Color = Color(0xFFFF649C),
            statusSuccessFill: Color = Color(0xFFB1FFE7),
            statusSuccessSpot: Color = Color(0xFF62F1C6),
            statusWarningFill: Color = Color(0xFFFBF1BB),
            statusWarningSpot: Color = Color(0xFFFEEB87),
            surfaceContrast: Color = Color(0xFF010913),
            surfaceDefault: Color = Color(0xFF131D2B),
            surfaceElevated: Color = Color(0xFF243346),
            surfaceHero: Color = Color(0xFF010913),
            surfaceHighlight: Color = Color(0xFF243346),
            surfaceLowContrast: Color = Color(0xFF243346),
            surfaceSubtle: Color = Color(0xFF243346),
            textDisabled: Color = Color(0x33FFFFFF),
            textDisabledOnDark: Color = Color(0x80FFFFFF),
            textError: Color = Color(0xFFFF649C),
            textHero: Color = Color(0xFF010913),
            textLink: Color = Color(0xFF84E9FF),
            textOnDark: Color = Color(0xFFFFFFFF),
            textOnLight: Color = Color(0xFF010913),
            textPrimary: Color = Color(0xFFFFFFFF),
            textPrimaryInverse: Color = Color(0xFF010913),
            textSecondary: Color = Color(0xFFBDC4CB),
        ): BpkColors = BpkColors(
            isLight = false,
            canvas = canvas,
            canvasContrast = canvasContrast,
            coreAccent = coreAccent,
            coreEco = coreEco,
            corePrimary = corePrimary,
            line = line,
            lineOnDark = lineOnDark,
            overlay = overlay,
            scrim = scrim,
            statusDangerFill = statusDangerFill,
            statusDangerSpot = statusDangerSpot,
            statusSuccessFill = statusSuccessFill,
            statusSuccessSpot = statusSuccessSpot,
            statusWarningFill = statusWarningFill,
            statusWarningSpot = statusWarningSpot,
            surfaceContrast = surfaceContrast,
            surfaceDefault = surfaceDefault,
            surfaceElevated = surfaceElevated,
            surfaceHero = surfaceHero,
            surfaceHighlight = surfaceHighlight,
            surfaceLowContrast = surfaceLowContrast,
            surfaceSubtle = surfaceSubtle,
            textDisabled = textDisabled,
            textDisabledOnDark = textDisabledOnDark,
            textError = textError,
            textHero = textHero,
            textLink = textLink,
            textOnDark = textOnDark,
            textOnLight = textOnLight,
            textPrimary = textPrimary,
            textPrimaryInverse = textPrimaryInverse,
            textSecondary = textSecondary,
        )
    }
}
