/**
 * Backpack for Android - Skyscanner's Design System
 *
 * Copyright 2018 Skyscanner Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.skyscanner.backpack.util

import android.graphics.Bitmap
import android.graphics.Canvas
import android.graphics.Color
import android.view.View

internal inline fun View.rasterize(
    widthMeasureSpec: Int = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED),
    heightMeasureSpec: Int = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED),
    bitmapConfig: Bitmap.Config = Bitmap.Config.ARGB_8888,
    onLayoutDone: (View) -> Unit = {},
): Bitmap {

    measure(widthMeasureSpec, heightMeasureSpec)
    layout(0, 0, measuredWidth, measuredHeight)

    onLayoutDone(this)

    val bitmap = Bitmap.createBitmap(width, height, bitmapConfig)
    bitmap.eraseColor(Color.TRANSPARENT)
    draw(Canvas(bitmap))

    return bitmap
}
