/**
 * Backpack for Android - Skyscanner's Design System
 *
 * Copyright 2018 Skyscanner Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.skyscanner.backpack.chip.internal

import android.content.res.ColorStateList
import android.graphics.drawable.Drawable
import androidx.annotation.ColorInt
import net.skyscanner.backpack.chip.BpkChip

internal interface BpkChipAppearance {
    val style: BpkChip.Style

    val background: Drawable

    val dismissibleBackground: Drawable

    val text: ColorStateList

    val dismissibleText: ColorStateList

    val dismissibleIcon: ColorStateList

    @get:ColorInt
    @setparam:ColorInt
    var selectedBackgroundColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var pressedBackgroundColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var backgroundColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var disabledBackgroundColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var textColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var pressedTextColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var selectedTextColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var dismissibleIconColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var strokeColor: Int

    @get:ColorInt
    @setparam:ColorInt
    var pressedStrokeColor: Int
}
