/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr;

import an.awesome.pipelinr.Command;
import an.awesome.pipelinr.CommandHandlerNotFoundException;
import an.awesome.pipelinr.CommandHandlers;
import an.awesome.pipelinr.CommandHasMultipleHandlersException;
import an.awesome.pipelinr.Notification;
import an.awesome.pipelinr.NotificationHandlers;
import an.awesome.pipelinr.NotificationHandlingStrategy;
import an.awesome.pipelinr.Pipeline;
import an.awesome.pipelinr.PipelineStep;
import an.awesome.pipelinr.PipelineSteps;
import an.awesome.pipelinr.Preconditions;
import an.awesome.pipelinr.StopOnException;
import an.awesome.pipelinr.StreamSupplier;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Pipelinr
implements Pipeline {
    private final Command.Router router = new ToFirstMatching();
    private boolean legacyPipelineSteps = false;
    private StreamSupplier<PipelineStep> steps = Stream::empty;
    private StreamSupplier<Command.Middleware> commandMiddlewares = Stream::empty;
    private StreamSupplier<Command.Handler> commandHandlers = Stream::empty;
    private StreamSupplier<Notification.Middleware> notificationMiddlewares = Stream::empty;
    private StreamSupplier<Notification.Handler> notificationHandlers = Stream::empty;
    private Supplier<NotificationHandlingStrategy> notificationHandlingStrategySupplier = StopOnException::new;

    public Pipelinr() {
    }

    @Deprecated
    public Pipelinr(StreamSupplier<Command.Handler> commandHandlers) {
        this(commandHandlers, Stream::empty);
    }

    @Deprecated
    public Pipelinr(StreamSupplier<Command.Handler> commandHandlers, StreamSupplier<PipelineStep> steps) {
        this.commandHandlers = Preconditions.checkArgument(commandHandlers, "Command handlers must not be null");
        this.steps = Preconditions.checkArgument(steps, "Steps must not be null");
        this.legacyPipelineSteps = true;
    }

    public Pipelinr with(CommandHandlers commandHandlers) {
        Preconditions.checkArgument(commandHandlers, "Command handlers must not be null");
        this.commandHandlers = commandHandlers::supply;
        return this;
    }

    public Pipelinr with(NotificationHandlers notificationHandlers) {
        Preconditions.checkArgument(notificationHandlers, "Notification handlers must not be null");
        this.notificationHandlers = notificationHandlers::supply;
        return this;
    }

    public Pipelinr with(Notification.Middlewares middlewares) {
        Preconditions.checkArgument(middlewares, "Middlewares must not be null");
        this.notificationMiddlewares = middlewares::supply;
        return this;
    }

    public Pipelinr with(Command.Middlewares middlewares) {
        Preconditions.checkArgument(middlewares, "Middlewares must not be null");
        this.commandMiddlewares = middlewares::supply;
        return this;
    }

    public Pipelinr with(Supplier<NotificationHandlingStrategy> notificationHandlingStrategySupplier) {
        Preconditions.checkArgument(notificationHandlingStrategySupplier, "Notification handling strategy supplier must not be null");
        this.notificationHandlingStrategySupplier = notificationHandlingStrategySupplier;
        return this;
    }

    @Deprecated
    public Pipelinr with(PipelineSteps steps) {
        Preconditions.checkArgument(steps, "Pipeline steps must not be null");
        this.steps = steps::supply;
        this.legacyPipelineSteps = true;
        return this;
    }

    @Override
    public <R, C extends Command<R>> R send(C command) {
        Preconditions.checkArgument(command, "Command must not be null");
        if (this.legacyPipelineSteps) {
            Handle handleCommand = new Handle(this, command);
            return (R)this.steps.supplyEx().foldRight(handleCommand, (step, next) -> () -> step.invoke(command, next)).invoke();
        }
        HandleCommand handleCommand = new HandleCommand(this, command);
        return (R)this.commandMiddlewares.supplyEx().foldRight(handleCommand, (step, next) -> () -> step.invoke(command, next)).invoke();
    }

    @Override
    public <N extends Notification> void send(N notification) {
        Preconditions.checkArgument(notification, "Notification must not be null");
        List<Runnable> runnableNotifications = this.notificationHandlers.supply().filter(it -> it.matches(notification)).map(it -> {
            Notification.Middleware.Next handleNotification = () -> it.handle(notification);
            return () -> this.notificationMiddlewares.supplyEx().foldRight(handleNotification, (step, next) -> () -> step.invoke(notification, (Notification.Middleware.Next)next)).invoke();
        }).collect(Collectors.toList());
        NotificationHandlingStrategy notificationHandlingStrategy = this.notificationHandlingStrategySupplier.get();
        notificationHandlingStrategy.handle(runnableNotifications);
    }

    private class ToFirstMatching
    implements Command.Router {
        private ToFirstMatching() {
        }

        @Override
        public <C extends Command<R>, R> Command.Handler<C, R> route(C command) {
            boolean moreThanOneMatch;
            List<Command.Handler> matchingHandlers = Pipelinr.this.commandHandlers.supply().filter(handler -> handler.matches(command)).collect(Collectors.toList());
            boolean noMatches = matchingHandlers.isEmpty();
            if (noMatches) {
                throw new CommandHandlerNotFoundException(command);
            }
            boolean bl = moreThanOneMatch = matchingHandlers.size() > 1;
            if (moreThanOneMatch) {
                throw new CommandHasMultipleHandlersException(command, matchingHandlers);
            }
            return (Command.Handler)matchingHandlers.get(0);
        }
    }

    private static class HandleCommand<R, C extends Command<R>>
    implements Command.Middleware.Next<R> {
        private final C command;
        final /* synthetic */ Pipelinr this$0;

        public HandleCommand(C command) {
            this.this$0 = var1_1;
            this.command = command;
        }

        @Override
        public R invoke() {
            Command.Handler handler = this.this$0.router.route(this.command);
            return handler.handle(this.command);
        }
    }

    private static class Handle<R, C extends Command<R>>
    implements PipelineStep.Next<R> {
        private final C command;
        final /* synthetic */ Pipelinr this$0;

        public Handle(C command) {
            this.this$0 = var1_1;
            this.command = command;
        }

        @Override
        public R invoke() {
            Command.Handler handler = this.this$0.router.route(this.command);
            return handler.handle(this.command);
        }
    }
}

