/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr;

import an.awesome.pipelinr.AggregateException;
import an.awesome.pipelinr.NotificationHandlingStrategy;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public class ParallelWhenAll
implements NotificationHandlingStrategy {
    private final ExecutorService threadPool;

    public ParallelWhenAll(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void handle(List<Runnable> runnableNotifications) {
        CopyOnWriteArrayList<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
        CompletableFuture.allOf((CompletableFuture[])runnableNotifications.stream().map(runnable -> CompletableFuture.runAsync(runnable, this.threadPool).exceptionally(throwable -> {
            exceptions.add((Throwable)throwable);
            return null;
        })).toArray(CompletableFuture[]::new)).join();
        if (!exceptions.isEmpty()) {
            throw new AggregateException(exceptions);
        }
    }
}

