/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Generic<C> {
    private static final Map<Generic<?>, Type> RESOLVED_GENERICS = new ConcurrentHashMap();
    private final Class<?> context;
    private final Type diamond;
    final AtomicLong numberOfScans = new AtomicLong();

    protected Generic(Class<?> context) {
        this.context = context;
        this.diamond = this.capture();
    }

    private Type capture() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(superclass + " isn't parameterized");
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public Class<? super C> resolve() {
        return (Class)RESOLVED_GENERICS.computeIfAbsent(this, it -> {
            Mappings mappings = new Scanner().scan(this.context);
            this.numberOfScans.incrementAndGet();
            return mappings.get(this.diamond);
        });
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Generic)) {
            return false;
        }
        Generic other = (Generic)that;
        return this.context.equals(other.context) && this.diamond.equals(other.diamond);
    }

    public int hashCode() {
        return 31 * this.context.hashCode() + this.diamond.hashCode();
    }

    private static class Mappings {
        private final Map<TypeVariable<?>, Type> mappings = new HashMap();

        private Mappings() {
        }

        public void add(ParameterizedType type) {
            TypeVariable<Class<T>>[] generics = ((Class)type.getRawType()).getTypeParameters();
            Type[] concretes = type.getActualTypeArguments();
            for (int i = 0; i < generics.length; ++i) {
                this.mappings.put(generics[i], concretes[i]);
            }
        }

        public Type get(Type type) {
            if (type instanceof TypeVariable) {
                Type replacement = this.mappings.get(type);
                if (replacement != null) {
                    return this.get(replacement);
                }
            } else if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getRawType();
            }
            return type;
        }
    }

    private static class Scanner {
        private final Mappings mappings = new Mappings();

        private Scanner() {
        }

        public Mappings scan(Class<?> clazz) {
            this.scanSuperclass(clazz);
            this.scanInterfaces(clazz);
            return this.mappings;
        }

        private void scanSuperclass(Class<?> clazz) {
            Type superclass = clazz.getGenericSuperclass();
            if (superclass instanceof ParameterizedType) {
                this.mappings.add((ParameterizedType)superclass);
                this.scan((Class)((ParameterizedType)superclass).getRawType());
            } else if (superclass instanceof Class) {
                this.scan((Class)superclass);
            }
        }

        private void scanInterfaces(Class<?> clazz) {
            for (Type iface : clazz.getGenericInterfaces()) {
                if (!(iface instanceof ParameterizedType)) continue;
                this.mappings.add((ParameterizedType)iface);
                this.scan((Class)((ParameterizedType)iface).getRawType());
            }
        }
    }
}

