/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr;

import an.awesome.pipelinr.AggregateException;
import an.awesome.pipelinr.NotificationHandlingStrategy;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public class Async
implements NotificationHandlingStrategy {
    private final ExecutorService threadPool;

    public Async(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void handle(List<Runnable> runnableNotifications) {
        CopyOnWriteArrayList<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
        CompletableFuture.runAsync(() -> runnableNotifications.forEach(it -> {
            try {
                it.run();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }), this.threadPool).join();
        if (!exceptions.isEmpty()) {
            throw new AggregateException(exceptions);
        }
    }
}

