package net.sinyax.sofa.web;

import net.sinyax.sofa.ConflictingVersionException;
import net.sinyax.sofa.storage.DocumentNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import java.util.Map;

@ControllerAdvice
public class ErrorHandlers {
  @ExceptionHandler(DocumentNotFoundException.class)
  public ResponseEntity<Map<String, String>>
  documentNotFound(DocumentNotFoundException e) {
    return new ResponseEntity<>(Map.of(
      "error", "not_found",
      "reason", "missing"
    ), HttpStatus.NOT_FOUND);
  }

  @ExceptionHandler(ConflictingVersionException.class)
  public ResponseEntity<Map<String, String>>
  conflictingVersion(ConflictingVersionException e) {
    return new ResponseEntity<>(Map.of(
      "error", "conflict",
      "reason", "conflicting version"
    ), HttpStatus.CONFLICT);
  }
}
