/*
 * Decompiled with CFR 0.152.
 */
package net.sinyax.sofa.web;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinyax.sofa.ConflictingVersionException;
import net.sinyax.sofa.Database;
import net.sinyax.sofa.doc.Document;
import net.sinyax.sofa.doc.ImmutableDocumentImpl;
import net.sinyax.sofa.storage.DocumentNotFoundException;
import net.sinyax.sofa.storage.InMemoryStorage;
import net.sinyax.sofa.storage.Storage;
import net.sinyax.sofa.web.dto.BulkUpdate;
import net.sinyax.sofa.web.dto.RevDiffResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{dbName:[a-z][a-zA-Z0-9_.-]*}"})
public class DbController {
    Logger log = LoggerFactory.getLogger(DbController.class);
    private final Map<String, Database> openDbs = new HashMap<String, Database>();

    private Database getDb(String dbName) {
        Database db = this.openDbs.get(dbName);
        if (db != null) {
            return db;
        }
        Database newDb = new Database((Storage)new InMemoryStorage());
        this.openDbs.put(dbName, newDb);
        return newDb;
    }

    @GetMapping(value={""})
    Map<String, Object> getDbInfo(@PathVariable String dbName) {
        return Map.of("db_name", dbName, "purge_seq", "0", "update_seq", "0", "doc_del_count", 0, "doc_count", 0, "compact_running", false, "instance_start_time", "0");
    }

    @PostMapping(value={"_ensure_full_commit"})
    @ResponseStatus(value=HttpStatus.CREATED)
    Map<String, Object> ensureFullCommit(@PathVariable String dbName) {
        Database db = this.getDb(dbName);
        db.ensureFullCommit();
        return Map.of("ok", true, "instance_start_time", "0");
    }

    @GetMapping(value={"_all_docs"})
    List<Document> allDocs(@PathVariable String dbName) {
        Database db = this.getDb(dbName);
        return db.getAllDocuments().collect(Collectors.toList());
    }

    @PostMapping(value={"_bulk_docs"})
    @ResponseStatus(value=HttpStatus.CREATED)
    List<Map<String, Object>> bulkDocs(@PathVariable String dbName, @RequestBody BulkUpdate bulkUpdate) {
        Database db = this.getDb(dbName);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        boolean newEdits = bulkUpdate.getNewEdits();
        for (Document doc : bulkUpdate.getDocs()) {
            try {
                Document saved = db.save(doc, newEdits);
                if (!newEdits) continue;
                result.add(Map.of("ok", true, "id", saved.getId(), "rev", saved.getRevision()));
            }
            catch (ConflictingVersionException e) {
                if (!newEdits) continue;
                result.add(Map.of("error", "conflict", "reason", e.getMessage()));
            }
            catch (RuntimeException e) {
                if (!newEdits) continue;
                result.add(Map.of("error", "unknown", "reason", e.getMessage()));
            }
        }
        return result;
    }

    @PostMapping(value={""})
    Map<String, Object> createNewDocument(@PathVariable String dbName, @RequestBody Map<String, Object> newDoc) {
        Database db = this.getDb(dbName);
        Document saved = db.save((Document)new ImmutableDocumentImpl((String)newDoc.get("_id"), (String)newDoc.get("_rev"), newDoc.entrySet().stream().filter(e -> !((String)e.getKey()).equals("_id") && !((String)e.getKey()).equals("_rev")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()))));
        return Map.of("ok", true, "id", saved.getId(), "rev", saved.getRevision());
    }

    @PostMapping(value={"/_revs_diff"})
    Map<String, RevDiffResponse> revsDiff(@PathVariable String dbName, @RequestBody Map<String, List<String>> req) {
        this.log.info("Revs DIFF: {} : {}", (Object)dbName, req);
        return req.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, RevDiffResponse>((String)e.getKey(), new RevDiffResponse((List)e.getValue(), List.of()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @GetMapping(value={"/{docId:[^_].*}"})
    Document getDocumentById(@PathVariable String dbName, @PathVariable String docId) {
        this.log.info("DB GET: {} / {}", (Object)dbName, (Object)docId);
        Database db = this.getDb(dbName);
        Document doc = db.getDocument(docId);
        return doc;
    }

    @PutMapping(value={"/{docId:[^_].*}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    Map<String, Object> putDocumentById(@PathVariable String dbName, @PathVariable String docId, @RequestParam(name="rev", required=false) String rev, @RequestParam(name="new_edits", defaultValue="true", required=false) boolean newEdits, @RequestHeader(value="if-match", required=false) String ifMatch, @RequestBody Document doc) {
        Database db = this.getDb(dbName);
        String docRev = doc.getRevision() != null ? doc.getRevision() : (rev != null ? rev : ifMatch);
        ImmutableDocumentImpl docToSave = new ImmutableDocumentImpl(docId, docRev, doc.isDeleted(), doc.copyBody(), null);
        Document savedDoc = db.save((Document)docToSave, newEdits);
        return Map.of("id", savedDoc.getId(), "rev", savedDoc.getRevision(), "ok", true);
    }

    @GetMapping(value={"/_local/{docId}"})
    Document getLocalDocument(@PathVariable String dbName, @PathVariable String docId) {
        Database db = this.getDb(dbName);
        return db.getLocalDocument(docId);
    }

    @PutMapping(value={"/_local/{docId}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    Map<String, Object> putLocalDocument(@PathVariable String dbName, @PathVariable String docId, @RequestParam(name="rev", required=false) String rev, @RequestHeader(value="if-match", required=false) String ifMatch, @RequestBody Document doc) {
        Database db = this.getDb(dbName);
        String docRev = doc.getRevision() != null ? doc.getRevision() : (rev != null ? rev : ifMatch);
        ImmutableDocumentImpl docToSave = new ImmutableDocumentImpl(docId, docRev, doc.isDeleted(), doc.copyBody(), null);
        Document savedDoc = db.saveLocal((Document)docToSave);
        return Map.of("id", savedDoc.getId(), "rev", savedDoc.getRevision(), "ok", true);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public static class HttpDocumentNotFoundException
    extends DocumentNotFoundException {
        public HttpDocumentNotFoundException(String docId) {
            super(docId);
        }
    }
}

