/*
 * Decompiled with CFR 0.152.
 */
package net.sinyax.sofa;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import net.sinyax.sofa.CommonEncoding;
import net.sinyax.sofa.ReplicatorDbAdapter;
import net.sinyax.sofa.doc.ChangeRecord;
import net.sinyax.sofa.doc.Document;
import net.sinyax.sofa.doc.ImmutableDocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Replicator.class);
    private static final String VERSION = "1";
    private final ReplicatorDbAdapter source;
    private final ReplicatorDbAdapter target;
    private final int batchSize;
    private final String replicationDocId;
    private int replicatedDocumentCount;
    private String startSeq;
    private String syncSeq;
    private Optional<Document> replDocSource;
    private Optional<Document> replDocTarget;

    public Replicator(ReplicatorDbAdapter source, ReplicatorDbAdapter target) {
        this.source = source;
        this.target = target;
        this.startSeq = "0";
        this.syncSeq = "0";
        this.batchSize = 100;
        this.replicationDocId = "_local/sofa.replication_status:" + this.replicationId();
        this.replicatedDocumentCount = 0;
    }

    private String replicationId() {
        String sourceId = this.source.identifier();
        String targetId = this.target.identifier();
        String full = sourceId.replace(">", ">>") + "->" + targetId;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = md.digest(full.getBytes(StandardCharsets.UTF_8));
        return CommonEncoding.hexEncode((byte[])digest);
    }

    public void preflight() throws ExecutionException, InterruptedException {
        this.replDocSource = this.source.getLocalDocument(this.replicationDocId).get();
        this.replDocTarget = this.target.getLocalDocument(this.replicationDocId).get();
        LOGGER.debug("begin repl preflight from {} to {}", (Object)this.source.identifier(), (Object)this.target.identifier());
        if (this.replDocSource.isPresent() && this.replDocTarget.isPresent()) {
            String versionFromSource = this.replDocSource.map(d -> d.getString("sofa_replication_id_version")).orElse("-");
            String versionFromTarget = this.replDocTarget.map(d -> d.getString("sofa_replication_id_version")).orElse("-");
            String sourceLastSeqFromSource = this.replDocSource.map(d -> d.getString("source_last_seq")).orElse(null);
            String sourceLastSeqFromTarget = this.replDocTarget.map(d -> d.getString("source_last_seq")).orElse(null);
            if (sourceLastSeqFromSource != null && Objects.equals(sourceLastSeqFromSource, sourceLastSeqFromTarget) && VERSION.equals(versionFromSource) && VERSION.equals(versionFromTarget)) {
                this.startSeq = sourceLastSeqFromSource;
                LOGGER.debug("start seq for replication set to: {}", (Object)this.startSeq);
            }
        }
        this.syncSeq = this.startSeq;
    }

    public boolean step() throws ExecutionException, InterruptedException {
        List<ChangeRecord> changes = this.source.getChanges(this.syncSeq, this.batchSize).get();
        HashMap<String, Object> idsToReplicate = new HashMap<String, Object>();
        for (ChangeRecord change : changes) {
            Object revSet = (HashSet)idsToReplicate.get(change.id);
            List list = change.leaves;
            if (revSet == null) {
                revSet = new HashSet(list);
                idsToReplicate.put(change.id, revSet);
                continue;
            }
            ((AbstractCollection)revSet).addAll(list);
        }
        if (changes.isEmpty()) {
            return false;
        }
        String lastSeqInBatch = changes.get((int)(changes.size() - 1)).seq;
        HashMap<String, List<String>> revisionList = new HashMap<String, List<String>>(idsToReplicate.size());
        for (Map.Entry entry : idsToReplicate.entrySet()) {
            revisionList.put((String)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        Map<String, Map<String, List<String>>> diffIds = this.target.getRevisionDiff(revisionList).get();
        ArrayList<Document> arrayList = new ArrayList<Document>(idsToReplicate.size());
        for (Map.Entry<String, Map<String, List<String>>> taskEntry : diffIds.entrySet()) {
            List<String> missing = taskEntry.getValue().get("missing");
            if (missing == null || missing.isEmpty()) continue;
            String docId = taskEntry.getKey();
            this.source.getDocument(docId, true, missing).get().stream().filter(drr -> drr.doc != null).map(drr -> drr.doc).forEach(arrayList::add);
        }
        this.target.bulkSaveDocuments(arrayList, false).get();
        this.replicatedDocumentCount += arrayList.size();
        this.syncSeq = lastSeqInBatch;
        return true;
    }

    public void storeCheckpoint() {
        if (this.syncSeq.equals(this.startSeq)) {
            return;
        }
        ImmutableDocumentImpl newReplDocSource = new ImmutableDocumentImpl(this.replicationDocId, (String)this.replDocSource.map(Document::getRevision).orElse(null), Map.of("sofa_replication_id_version", VERSION, "source_last_seq", this.syncSeq));
        ImmutableDocumentImpl newReplDocTarget = new ImmutableDocumentImpl(this.replicationDocId, (String)this.replDocTarget.map(Document::getRevision).orElse(null), newReplDocSource.copyBody());
        this.source.saveLocalDocument((Document)newReplDocSource);
        this.target.saveLocalDocument((Document)newReplDocTarget);
        this.startSeq = this.syncSeq;
    }

    public int getReplicatedDocumentCount() {
        return this.replicatedDocumentCount;
    }
}

