/*
 * Decompiled with CFR 0.152.
 */
package net.sinyax.sofa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.sinyax.sofa.HttpResponseStatusException;
import net.sinyax.sofa.ReplicatorDbAdapter;
import net.sinyax.sofa.doc.ChangeRecord;
import net.sinyax.sofa.doc.Document;
import net.sinyax.sofa.doc.ImmutableDocumentImpl;
import net.sinyax.sofa.dto.BulkUpdate;
import net.sinyax.sofa.dto.ChangesResponse;
import net.sinyax.sofa.dto.DatabaseInfo;
import net.sinyax.sofa.dto.DocRevResponse;
import net.sinyax.sofa.dto.DocSaveResponse;
import net.sinyax.sofa.json.JacksonModule;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteHttpDatabase
implements ReplicatorDbAdapter {
    private final String baseUrl;
    private final OkHttpClient http;
    private final ObjectMapper om;
    @Nullable
    private final String authentication;
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    private final String userAgent;

    public RemoteHttpDatabase(String baseUrl, @Nullable String authentication, @Nullable String userAgent) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.http = new OkHttpClient.Builder().build();
        this.om = new ObjectMapper();
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.registerModule((Module)new JacksonModule());
        this.authentication = authentication;
        this.userAgent = Objects.requireNonNullElse(userAgent, "sofa-replication");
    }

    public RemoteHttpDatabase(String baseUrl, @Nullable String authentication) {
        this(baseUrl, authentication, null);
    }

    private CompletableFuture<Response> asyncCall(Request request) {
        final CompletableFuture<Response> cf = new CompletableFuture<Response>();
        this.http.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                cf.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                if (response.code() >= 200 && response.code() < 400) {
                    cf.complete(response);
                } else {
                    cf.completeExceptionally(new HttpResponseStatusException(response.code(), response.message()));
                }
            }
        });
        return cf;
    }

    @Override
    public String identifier() {
        return this.baseUrl;
    }

    @Override
    public CompletableFuture<DatabaseInfo> info() {
        Request req = this.request("", null).get().build();
        return this.asyncCall(req).thenApply(res -> {
            try {
                return (DatabaseInfo)this.om.readValue(res.body().byteStream(), DatabaseInfo.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<ChangeRecord>> getChanges(String since, int limit) {
        Request req = this.request("_changes", Map.of("since", since, "style", "all_docs", "limit", Integer.toString(limit))).get().build();
        return this.asyncCall(req).thenApply(res -> {
            try {
                return ((ChangesResponse)this.om.readValue((InputStream)res.body().byteStream(), ChangesResponse.class)).results.stream().map(cr -> new ChangeRecord(cr.id, cr.seq, cr.changes.stream().map(chRev -> chRev.rev).collect(Collectors.toList()), cr.deleted)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Request.Builder request(String path, @Nullable Map<String, String> params) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(this.baseUrl + path)).newBuilder();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                urlBuilder = urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpUrl url = urlBuilder.build();
        Request.Builder builder = new Request.Builder().header("User-Agent", this.userAgent).url(url);
        if (this.authentication != null) {
            builder = builder.addHeader("authorization", this.authentication);
        }
        return builder;
    }

    @Override
    public CompletableFuture<Document> getDocument(String docId, boolean revs) {
        Request req = this.request(docId, Map.of("revs", Boolean.toString(revs))).get().build();
        return this.asyncCall(req).thenApply(res -> {
            try {
                return (Document)this.om.readValue(res.body().byteStream(), Document.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<DocRevResponse>> getDocument(String docId, boolean revs, List<String> revisions) {
        try {
            Request req = this.request(docId, Map.of("revs", Boolean.toString(revs), "open_revs", this.om.writeValueAsString(revisions))).addHeader("accept", "application/json").get().build();
            return this.asyncCall(req).thenApply(res -> {
                try {
                    return (List)this.om.readValue(res.body().byteStream(), (TypeReference)new TypeReference<List<DocRevResponse>>(){});
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<List<DocSaveResponse>> bulkSaveDocuments(List<Document> docs, boolean newEdits) {
        try {
            BulkUpdate body = new BulkUpdate();
            body.setDocs(docs);
            body.setNewEdits(newEdits);
            Request req = this.request("_bulk_docs", Map.of()).post(RequestBody.create((byte[])this.om.writeValueAsBytes((Object)body), (MediaType)APPLICATION_JSON)).build();
            return this.asyncCall(req).thenApply(res -> {
                try {
                    return (List)this.om.readValue(res.body().byteStream(), (TypeReference)new TypeReference<List<DocSaveResponse>>(){});
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Optional<Document>> getLocalDocument(String docId) {
        assert (docId.startsWith("_local/"));
        Request req = this.request(docId, Map.of()).get().build();
        final CompletableFuture<Optional<Document>> cf = new CompletableFuture<Optional<Document>>();
        this.http.newCall(req).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e1) {
                cf.completeExceptionally(e1);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                if (response.code() >= 200 && response.code() < 400) {
                    Document doc = (Document)RemoteHttpDatabase.this.om.readValue(response.body().byteStream(), Document.class);
                    cf.complete(Optional.of(doc));
                } else if (response.code() == 404) {
                    cf.complete(Optional.empty());
                } else {
                    cf.completeExceptionally(new HttpResponseStatusException(response.code(), response.message()));
                }
            }
        });
        return cf;
    }

    @Override
    public CompletableFuture<Document> saveLocalDocument(Document doc) {
        String docId = doc.getId();
        assert (docId.startsWith("_local/"));
        Map body = doc.copyBody();
        try {
            Request req = this.request(docId, Map.of()).put(RequestBody.create((byte[])this.om.writeValueAsBytes((Object)body), (MediaType)APPLICATION_JSON)).build();
            return this.asyncCall(req).thenApply(res -> {
                try {
                    DocSaveResponse response = (DocSaveResponse)this.om.readValue(res.body().byteStream(), DocSaveResponse.class);
                    if (!response.ok) {
                        throw new RuntimeException("doc saving failed: " + docId);
                    }
                    return new ImmutableDocumentImpl(response.id, response.rev, doc.isDeleted(), body, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, Map<String, List<String>>>> getRevisionDiff(Map<String, List<String>> revs) {
        try {
            Request req = this.request("_revs_diff", Map.of()).post(RequestBody.create((byte[])this.om.writeValueAsBytes(revs), (MediaType)APPLICATION_JSON)).build();
            return this.asyncCall(req).thenApply(res -> {
                try {
                    return (Map)this.om.readValue(res.body().byteStream(), (TypeReference)new TypeReference<Map<String, Map<String, List<String>>>>(){});
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

