/*
 * Decompiled with CFR 0.152.
 */
package net.sinyax.sofa;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.sinyax.sofa.Database;
import net.sinyax.sofa.ReplicatorDbAdapter;
import net.sinyax.sofa.doc.ChangeRecord;
import net.sinyax.sofa.doc.Document;
import net.sinyax.sofa.dto.DatabaseInfo;
import net.sinyax.sofa.dto.DocRevResponse;
import net.sinyax.sofa.dto.DocSaveResponse;
import net.sinyax.sofa.storage.DocumentNotFoundException;

public class LocalDatabase
implements ReplicatorDbAdapter {
    private final Database db;

    public LocalDatabase(Database db) {
        this.db = db;
    }

    private static <T> CompletableFuture<T> wrap(T value) {
        CompletableFuture<T> cf = new CompletableFuture<T>();
        cf.complete(value);
        return cf;
    }

    @Override
    public String identifier() {
        return this.db.getDatabaseIdentifier();
    }

    @Override
    public CompletableFuture<DatabaseInfo> info() {
        DatabaseInfo dbInfo = new DatabaseInfo();
        return LocalDatabase.wrap(dbInfo);
    }

    @Override
    public CompletableFuture<List<ChangeRecord>> getChanges(String since, int limit) {
        return LocalDatabase.wrap(this.db.getChanges(since).limit(limit).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Document> getDocument(String docId, boolean revs) {
        if (revs) {
            throw new RuntimeException("not implemented: fetch revs=true");
        }
        return LocalDatabase.wrap(this.db.getDocument(docId));
    }

    @Override
    public CompletableFuture<List<DocRevResponse>> getDocument(String docId, boolean revs, List<String> revisions) {
        List docs = this.db.getDocument(docId, revs, revisions);
        ArrayList<DocRevResponse> result = new ArrayList<DocRevResponse>(docs.size());
        for (int i = 0; i < docs.size(); ++i) {
            DocRevResponse r = new DocRevResponse();
            Optional doc = (Optional)docs.get(i);
            if (doc.isPresent()) {
                r.doc = (Document)doc.orElseThrow();
            } else {
                r.missingRevId = revisions.get(i);
            }
            result.add(r);
        }
        return LocalDatabase.wrap(result);
    }

    @Override
    public CompletableFuture<List<DocSaveResponse>> bulkSaveDocuments(List<Document> docs, boolean newEdits) {
        ArrayList<DocSaveResponse> response = new ArrayList<DocSaveResponse>(docs.size());
        for (Document doc : docs) {
            Document saved = this.db.save(doc, newEdits);
            if (!newEdits) continue;
            response.add(new DocSaveResponse(saved.getId(), saved.getRevision(), true));
        }
        return LocalDatabase.wrap(response);
    }

    @Override
    public CompletableFuture<Optional<Document>> getLocalDocument(String docId) {
        try {
            return LocalDatabase.wrap(Optional.of(this.db.getLocalDocument(docId)));
        }
        catch (DocumentNotFoundException e) {
            return LocalDatabase.wrap(Optional.empty());
        }
    }

    @Override
    public CompletableFuture<Document> saveLocalDocument(Document doc) {
        Document saved = this.db.saveLocal(doc);
        return LocalDatabase.wrap(saved);
    }

    @Override
    public CompletableFuture<Map<String, Map<String, List<String>>>> getRevisionDiff(Map<String, List<String>> revs) {
        return LocalDatabase.wrap(this.db.revsDiff(revs));
    }
}

