package net.sinyax.sofa;

import net.sinyax.sofa.doc.Document;
import net.sinyax.sofa.doc.ChangeRecord;
import net.sinyax.sofa.dto.DatabaseInfo;
import net.sinyax.sofa.dto.DocRevResponse;
import net.sinyax.sofa.dto.DocSaveResponse;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface ReplicatorDbAdapter {
  String identifier();
  CompletableFuture<DatabaseInfo> info();
  CompletableFuture<List<ChangeRecord>> getChanges(String since, int limit);
  CompletableFuture<Document> getDocument(String docId, boolean revs);
  CompletableFuture<List<DocRevResponse>> getDocument(String docId, boolean revs, List<String> revisions);
  CompletableFuture<List<DocSaveResponse>> bulkSaveDocuments(List<Document> docs, boolean newEdits);
  CompletableFuture<Optional<Document>> getLocalDocument(String docId);
  CompletableFuture<Document> saveLocalDocument(Document doc);
  CompletableFuture<Map<String, Map<String, List<String>>>> getRevisionDiff(Map<String, List<String>> revs);
}
