/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.wechat.mp.msg;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sinofool.wechat.WeChatException;
import net.sinofool.wechat.mp.msg.IncomingClickEventMessage;
import net.sinofool.wechat.mp.msg.IncomingLocationEventMessage;
import net.sinofool.wechat.mp.msg.IncomingSubscribeEventMessage;
import net.sinofool.wechat.mp.msg.IncomingSubscribeWithScanEventMessage;
import net.sinofool.wechat.mp.msg.IncomingTextMessage;
import net.sinofool.wechat.mp.msg.IncomingViewEventMessage;
import net.sinofool.wechat.mp.msg.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Messages {
    private static final Logger LOG = LoggerFactory.getLogger(Messages.class);

    public static Message parseIncoming(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes(Charset.forName("utf-8"))));
            Element root = doc.getDocumentElement();
            String type = root.getElementsByTagName("MsgType").item(0).getTextContent();
            if ("text".equals(type)) {
                return Messages.handleText(root);
            }
            if ("event".equals(type)) {
                return Messages.handleEvent(root);
            }
            return null;
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to parse incoming message:", (Throwable)e);
            throw new WeChatException(e);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse incoming message", (Throwable)e);
            throw new WeChatException(e);
        }
    }

    private static Message handleEvent(Element root) {
        String event;
        switch (event = Messages.e(root, "Event")) {
            case "subscribe": {
                if (root.getElementsByTagName("EventKey").getLength() == 0) {
                    IncomingSubscribeWithScanEventMessage msg = new IncomingSubscribeWithScanEventMessage();
                    msg.setFromUserName(Messages.e(root, "FromUserName"));
                    msg.setToUserName(Messages.e(root, "ToUserName"));
                    msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
                    msg.setEvent(event);
                    msg.setEventKey(Messages.e(root, "EventKey"));
                    msg.setTicket(Messages.e(root, "Ticket"));
                    return msg;
                }
            }
            case "unsubscribe": {
                IncomingSubscribeEventMessage msg = new IncomingSubscribeEventMessage();
                msg.setFromUserName(Messages.e(root, "FromUserName"));
                msg.setToUserName(Messages.e(root, "ToUserName"));
                msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
                msg.setEvent(event);
                return msg;
            }
            case "SCAN": {
                IncomingSubscribeWithScanEventMessage msg = new IncomingSubscribeWithScanEventMessage();
                msg.setFromUserName(Messages.e(root, "FromUserName"));
                msg.setToUserName(Messages.e(root, "ToUserName"));
                msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
                msg.setEvent(event);
                msg.setEventKey(Messages.e(root, "EventKey"));
                msg.setTicket(Messages.e(root, "Ticket"));
                return msg;
            }
            case "LOCATION": {
                IncomingLocationEventMessage msg = new IncomingLocationEventMessage();
                msg.setFromUserName(Messages.e(root, "FromUserName"));
                msg.setToUserName(Messages.e(root, "ToUserName"));
                msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
                msg.setEvent(event);
                msg.setLatitude(Double.parseDouble(Messages.e(root, "Latitude")));
                msg.setLongitude(Double.parseDouble(Messages.e(root, "Longitude")));
                msg.setPrecision(Double.parseDouble(Messages.e(root, "Precision")));
                return msg;
            }
            case "CLICK": {
                IncomingClickEventMessage msg = new IncomingClickEventMessage();
                msg.setFromUserName(Messages.e(root, "FromUserName"));
                msg.setToUserName(Messages.e(root, "ToUserName"));
                msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
                msg.setEvent(event);
                msg.setEventKey(Messages.e(root, "EventKey"));
                return msg;
            }
            case "VIEW": {
                IncomingViewEventMessage msg = new IncomingViewEventMessage();
                msg.setFromUserName(Messages.e(root, "FromUserName"));
                msg.setToUserName(Messages.e(root, "ToUserName"));
                msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
                msg.setEvent(event);
                msg.setEventKey(Messages.e(root, "EventKey"));
                return msg;
            }
        }
        return null;
    }

    private static String e(Element root, String element) {
        return root.getElementsByTagName(element).item(0).getTextContent();
    }

    private static Message handleText(Element root) throws ParserConfigurationException, TransformerException {
        IncomingTextMessage msg = new IncomingTextMessage();
        msg.setFromUserName(Messages.e(root, "FromUserName"));
        msg.setToUserName(Messages.e(root, "ToUserName"));
        msg.setCreateTime(Integer.parseInt(Messages.e(root, "CreateTime")));
        msg.setContent(Messages.e(root, "Content"));
        msg.setMsgId(Long.parseLong(Messages.e(root, "MsgId")));
        return msg;
    }
}

