/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.wechat.mp;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.sinofool.wechat.WeChatException;
import net.sinofool.wechat.thirdparty.org.json.JSONArray;
import net.sinofool.wechat.thirdparty.org.json.JSONException;
import net.sinofool.wechat.thirdparty.org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WeChatUtils.class);
    public static final Random RAND = new Random(System.currentTimeMillis());
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String NONCE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public static int now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private static String hex(byte[] input, boolean upperCase) {
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < input.length; ++j) {
            if (upperCase) {
                buf.append(DIGITS_UPPER[input[j] >> 4 & 0xF]);
                buf.append(DIGITS_UPPER[input[j] & 0xF]);
                continue;
            }
            buf.append(DIGITS_LOWER[input[j] >> 4 & 0xF]);
            buf.append(DIGITS_LOWER[input[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String sha1hex(String input) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA1").digest(input.getBytes(Charset.forName("utf-8")));
            return WeChatUtils.hex(digest, false);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot find SHA1 digest algorithm", (Throwable)e);
            throw new WeChatException(e);
        }
    }

    public static String md5hex(String input) {
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(input.getBytes(Charset.forName("utf-8")));
            return WeChatUtils.hex(digest, false);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot find MD5 digest algorithm", (Throwable)e);
            throw new WeChatException(e);
        }
    }

    public static String md5HEX(String input) {
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(input.getBytes(Charset.forName("utf-8")));
            return WeChatUtils.hex(digest, true);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Cannot find MD5 digest algorithm", (Throwable)e);
            throw new WeChatException(e);
        }
    }

    public static String nonce() {
        int length = RAND.nextInt(5) + 5;
        char[] ret = new char[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = NONCE.charAt(RAND.nextInt(NONCE.length()));
        }
        return new String(ret);
    }

    public static String getJSONString(JSONObject obj, String key) {
        try {
            return obj.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static int getJSONInt(JSONObject obj, String key) {
        try {
            return obj.getInt(key);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public static JSONArray getJSONArray(JSONObject obj, String key) {
        try {
            return obj.getJSONArray(key);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

