/*
 * Decompiled with CFR 0.152.
 */
package net.sinofool.wechat.mp;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sinofool.wechat.WeChatException;
import net.sinofool.wechat.WeChatJSAPIConfig;
import net.sinofool.wechat.WeChatUserInfo;
import net.sinofool.wechat.base.OneLevelOnlyXML;
import net.sinofool.wechat.mp.WeChatMPAccessTokenStorage;
import net.sinofool.wechat.mp.WeChatMPConfig;
import net.sinofool.wechat.mp.WeChatMPEventHandler;
import net.sinofool.wechat.mp.WeChatMPHttpClient;
import net.sinofool.wechat.mp.WeChatUtils;
import net.sinofool.wechat.mp.msg.IncomingClickEventMessage;
import net.sinofool.wechat.mp.msg.IncomingLocationEventMessage;
import net.sinofool.wechat.mp.msg.IncomingScanEventMessage;
import net.sinofool.wechat.mp.msg.IncomingSubscribeEventMessage;
import net.sinofool.wechat.mp.msg.IncomingSubscribeWithScanEventMessage;
import net.sinofool.wechat.mp.msg.IncomingTextMessage;
import net.sinofool.wechat.mp.msg.IncomingViewEventMessage;
import net.sinofool.wechat.mp.msg.Message;
import net.sinofool.wechat.mp.msg.Messages;
import net.sinofool.wechat.mp.msg.PushJSONFormat;
import net.sinofool.wechat.mp.msg.ReplyXMLFormat;
import net.sinofool.wechat.thirdparty.org.json.JSONArray;
import net.sinofool.wechat.thirdparty.org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WeChatMP {
    public static final String WECHAT_MP_WEB_SCOPE_BASE = "snsapi_base";
    public static final String WECHAT_MP_WEB_SCOPE_USERINFO = "snsapi_userinfo";
    public static final String WECHAT_MP_WEB_LANG_ZHCN = "zh_CN";
    public static final String WECHAT_MP_WEB_LANG_ZHTW = "zh_TW";
    public static final String WECHAT_MP_WEB_LANG_EN = "en";
    private static final Logger LOG = LoggerFactory.getLogger(WeChatMP.class);
    private final WeChatMPConfig config;
    private final WeChatMPEventHandler eventHandler;
    private final WeChatMPHttpClient httpClient;
    private final WeChatMPAccessTokenStorage atStorage;
    private final byte[] appIdBytes;
    private final byte[] aesKeyBytes;

    public WeChatMP(WeChatMPConfig config, WeChatMPEventHandler eventHandler, WeChatMPHttpClient httpClient, WeChatMPAccessTokenStorage atStorage) {
        this.config = config;
        this.eventHandler = eventHandler;
        this.httpClient = httpClient;
        this.atStorage = atStorage;
        this.appIdBytes = config.getAppId().getBytes(Charset.forName("utf-8"));
        this.aesKeyBytes = (byte[])(config.getAESKey() != null ? DatatypeConverter.parseBase64Binary((String)(config.getAESKey() + "=")) : null);
        if (null != eventHandler) {
            eventHandler.setWeChatMP(this);
        }
    }

    public boolean isEncrypted() {
        return this.aesKeyBytes != null;
    }

    public String validate(String signature, String echostr, int timestamp, String nonce) {
        return this.verify(signature, timestamp, nonce) ? echostr : "";
    }

    public String incomingMessage(String signature, int timestamp, String nonce, String encryptType, String msgSignature, String body) {
        Message dec;
        String encMessage;
        if (!this.verify(signature, timestamp, nonce)) {
            LOG.warn("Failed while verify signature of request query");
            return null;
        }
        if (this.isEncrypted()) {
            if (!encryptType.equals("aes")) {
                LOG.warn("Supoort only encrypted account, please contact support for migration");
                return null;
            }
            encMessage = this.decryptMPMessage(this.verifyAndExtractEncryptedEnvelope(timestamp, nonce, msgSignature, body));
            if (encMessage == null) {
                LOG.warn("Failed to extract encrypted envelope");
                return null;
            }
        } else {
            encMessage = body;
        }
        if ((dec = Messages.parseIncoming(encMessage)) == null) {
            LOG.warn("Failed to decrypt message");
            return null;
        }
        ReplyXMLFormat rpl = this.dispatch(dec);
        if (rpl == null) {
            return null;
        }
        if (this.isEncrypted()) {
            String enc = this.encryptMPMessage(rpl.toReplyXMLString());
            if (enc == null) {
                LOG.warn("Failed to encrypt message");
                return null;
            }
            return this.packAndSignEncryptedEnvelope(enc, WeChatUtils.now(), WeChatUtils.nonce());
        }
        return rpl.toReplyXMLString();
    }

    private ReplyXMLFormat dispatch(Message dec) {
        if (dec instanceof IncomingTextMessage) {
            return this.eventHandler.handle((IncomingTextMessage)dec);
        }
        if (dec instanceof IncomingSubscribeEventMessage) {
            return this.eventHandler.handle((IncomingSubscribeEventMessage)dec);
        }
        if (dec instanceof IncomingSubscribeWithScanEventMessage) {
            return this.eventHandler.handle((IncomingSubscribeWithScanEventMessage)dec);
        }
        if (dec instanceof IncomingScanEventMessage) {
            return this.eventHandler.handle((IncomingScanEventMessage)dec);
        }
        if (dec instanceof IncomingLocationEventMessage) {
            return this.eventHandler.handle((IncomingLocationEventMessage)dec);
        }
        if (dec instanceof IncomingClickEventMessage) {
            return this.eventHandler.handle((IncomingClickEventMessage)dec);
        }
        if (dec instanceof IncomingViewEventMessage) {
            return this.eventHandler.handle((IncomingViewEventMessage)dec);
        }
        return null;
    }

    private String packAndSignEncryptedEnvelope(String enc, int createTime, String nonce) {
        OneLevelOnlyXML xml = new OneLevelOnlyXML();
        xml.createRootElement("xml");
        xml.createChild("Encrypt", enc);
        xml.createChild("MsgSignature", this.sign(createTime, nonce, enc));
        xml.createChild("TimeStamp", createTime);
        xml.createChild("Nonce", nonce);
        return xml.toXMLString();
    }

    private String verifyAndExtractEncryptedEnvelope(int timestamp, String nonce, String msgSignature, String body) {
        String encMessage = null;
        String toUserName = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document root = builder.parse(new ByteArrayInputStream(body.getBytes(Charset.forName("utf-8"))));
            Element doc = root.getDocumentElement();
            encMessage = doc.getElementsByTagName("Encrypt").item(0).getTextContent();
            toUserName = doc.getElementsByTagName("ToUserName").item(0).getTextContent();
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to parse XML:", (Throwable)e);
            throw new WeChatException(e);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML", (Throwable)e);
            throw new WeChatException(e);
        }
        if (!this.config.getOriginID().equals(toUserName)) {
            LOG.warn("Failed to parse encrypted envelope, ToUserName expected={} not {}", (Object)this.config.getOriginID(), (Object)toUserName);
            return null;
        }
        if (!this.verify(msgSignature, timestamp, nonce, encMessage)) {
            LOG.warn("Failed to verify encrypted envelope message signature.");
            return null;
        }
        return encMessage;
    }

    public String getAccessToken() {
        String token = this.atStorage.getAccessToken();
        if (token == null) {
            String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/cgi-bin/token?grant_type=client_credential&appid=" + this.config.getAppId() + "&secret=" + this.config.getAppSecret());
            JSONObject json = new JSONObject(ret);
            token = json.getString("access_token");
            this.atStorage.setAccessToken(token, json.getInt("expires_in"));
        }
        return token;
    }

    public WeChatUserInfo getUserInfo(String openid) {
        String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/cgi-bin/user/info?access_token=" + this.getAccessToken() + "&openid=" + openid);
        return this.parseWeChatUser(ret);
    }

    public <T extends PushJSONFormat> void pushMessage(T message) {
        String ret = this.httpClient.post("api.weixin.qq.com", 443, "https", "/cgi-bin/message/custom/send?access_token=" + this.getAccessToken(), message.toPushJSONString());
        JSONObject json = new JSONObject(ret);
        if (json.getInt("errcode") != 0) {
            throw new WeChatException(json.getInt("errcode") + ":" + json.getString("errmsg"));
        }
    }

    private boolean verify(String signature, int timestamp, String nonce) {
        Object[] verify = new String[]{this.config.getToken(), String.valueOf(timestamp), nonce};
        Arrays.sort(verify);
        return signature.equals(WeChatUtils.sha1hex((String)verify[0] + (String)verify[1] + (String)verify[2]));
    }

    private boolean verify(String signature, int timestamp, String nonce, String msg) {
        return signature.equals(this.sign(timestamp, nonce, msg));
    }

    private String sign(int timestamp, String nonce, String msg) {
        Object[] verify = new String[]{this.config.getToken(), String.valueOf(timestamp), nonce, msg};
        Arrays.sort(verify);
        return WeChatUtils.sha1hex((String)verify[0] + (String)verify[1] + (String)verify[2] + (String)verify[3]);
    }

    final String decryptMPMessage(String encMessage) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKeyBytes, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKeyBytes, 0, 16);
            cipher.init(2, (Key)keySpec, iv);
            byte[] aesMsg = DatatypeConverter.parseBase64Binary((String)encMessage);
            byte[] msg = cipher.doFinal(aesMsg);
            int length = (msg[16] & 0xFF) << 24 | (msg[17] & 0xFF) << 16 | (msg[18] & 0xFF) << 8 | msg[19] & 0xFF;
            if (20 + length + this.appIdBytes.length + msg[msg.length - 1] != msg.length) {
                LOG.warn("decrypt message length not match length={}, msg.length={}", (Object)length, (Object)msg.length);
                return null;
            }
            for (int i = 0; i < this.appIdBytes.length; ++i) {
                if (this.appIdBytes[i] == msg[20 + length + i]) continue;
                LOG.warn("decrypt message appid not match {} expected but {} in message", (Object)this.config.getAppId(), (Object)new String(msg, 20 + length, this.appIdBytes.length, Charset.forName("utf-8")));
                return null;
            }
            return new String(msg, 20, length, Charset.forName("utf-8"));
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to decrypt message:", (Throwable)e);
            throw new WeChatException(e);
        }
        catch (Exception e) {
            LOG.warn("Failed to decrypt message", (Throwable)e);
            throw new WeChatException(e);
        }
    }

    final String encryptMPMessage(String rpl) {
        try {
            int i;
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKeyBytes, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKeyBytes, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] messageBytes = rpl.getBytes(Charset.forName("utf-8"));
            int usefulLength = 20 + messageBytes.length + this.appIdBytes.length;
            int padLength = usefulLength % 32 == 0 ? 32 : 32 - usefulLength % 32;
            byte[] buff = new byte[usefulLength + padLength];
            byte[] rand = new byte[16];
            WeChatUtils.RAND.nextBytes(rand);
            for (i = 0; i < 16; ++i) {
                buff[i] = rand[i];
            }
            buff[19] = (byte)(messageBytes.length & 0xFF);
            buff[18] = (byte)(messageBytes.length >> 8 & 0xFF);
            buff[17] = (byte)(messageBytes.length >> 16 & 0xFF);
            buff[16] = (byte)(messageBytes.length >> 24 & 0xFF);
            for (i = 0; i < messageBytes.length; ++i) {
                buff[i + 20] = messageBytes[i];
            }
            for (i = 0; i < this.appIdBytes.length; ++i) {
                buff[i + 20 + messageBytes.length] = this.appIdBytes[i];
            }
            for (i = 0; i < padLength; ++i) {
                buff[i + usefulLength] = (byte)padLength;
            }
            byte[] msg = cipher.doFinal(buff);
            String enc = DatatypeConverter.printBase64Binary((byte[])msg);
            return enc;
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to decrypt message:", (Throwable)e);
            throw new WeChatException(e);
        }
        catch (Exception e) {
            LOG.warn("Failed to encrypt message", (Throwable)e);
            throw new WeChatException(e);
        }
    }

    public String webpageAuthorize(String redirectURI, String scope, String state) throws UnsupportedEncodingException {
        StringBuffer redirect = new StringBuffer();
        redirect.append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=");
        redirect.append(this.config.getAppId());
        redirect.append("&redirect_uri=");
        redirect.append(URLEncoder.encode(redirectURI, "utf-8"));
        redirect.append("&response_type=code&scope=");
        redirect.append(scope);
        redirect.append("&state=");
        redirect.append(state);
        redirect.append("#wechat_redirect");
        return redirect.toString();
    }

    public String webpageProcessCallback(String code, String state) {
        String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/sns/oauth2/access_token?appid=" + this.config.getAppId() + "&secret=" + this.config.getAppSecret() + "&code=" + code + "&grant_type=authorization_code");
        JSONObject json = new JSONObject(ret);
        String accessToken = json.getString("access_token");
        int expire = json.getInt("expires_in");
        String refreshToken = json.getString("refresh_token");
        String openId = json.getString("openid");
        String scope = json.getString("scope");
        this.atStorage.setWebpageAccessToken(openId, scope, accessToken, expire);
        this.atStorage.setWebpageRefreshToken(openId, scope, refreshToken);
        return openId;
    }

    public WeChatUserInfo webpageUserInfo(String openId, String lang) {
        String accessToken = this.atStorage.getWebpageAccessToken(openId, WECHAT_MP_WEB_SCOPE_USERINFO);
        String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/sns/userinfo?access_token=" + accessToken + "&openid=" + openId + "&lang=" + lang);
        return this.parseWeChatUser(ret);
    }

    private WeChatUserInfo parseWeChatUser(String ret) {
        WeChatUserInfo user = new WeChatUserInfo();
        JSONObject json = new JSONObject(ret);
        user.setOpenId(WeChatUtils.getJSONString(json, "openid"));
        user.setNickname(WeChatUtils.getJSONString(json, "nickname"));
        user.setSex(WeChatUtils.getJSONInt(json, "sex"));
        user.setProvince(WeChatUtils.getJSONString(json, "province"));
        user.setCity(WeChatUtils.getJSONString(json, "city"));
        user.setCountry(WeChatUtils.getJSONString(json, "country"));
        user.setHeadimgurl(WeChatUtils.getJSONString(json, "headimgurl"));
        JSONArray privs = WeChatUtils.getJSONArray(json, "privilege");
        if (privs != null) {
            for (int i = 0; i < privs.length(); ++i) {
                user.addPrivilege(privs.getString(i));
            }
        }
        user.setUnionid(WeChatUtils.getJSONString(json, "unionid"));
        return user;
    }

    public String getJSAPITicket() {
        String ticket = this.atStorage.getJSAPITicket();
        if (ticket == null) {
            String ret = this.httpClient.get("api.weixin.qq.com", 443, "https", "/cgi-bin/ticket/getticket?access_token=" + this.getAccessToken() + "&type=jsapi");
            JSONObject json = new JSONObject(ret);
            ticket = json.getString("ticket");
            this.atStorage.setJSAPITicket(ticket, json.getInt("expires_in"));
        }
        return ticket;
    }

    public WeChatJSAPIConfig getJSAPIConfig(String url) {
        String ticket = this.getJSAPITicket();
        String nonce = WeChatUtils.nonce();
        int timestamp = WeChatUtils.now();
        String signature = WeChatUtils.sha1hex("jsapi_ticket=" + ticket + "&noncestr=" + nonce + "&timestamp=" + timestamp + "&url=" + url);
        WeChatJSAPIConfig ret = new WeChatJSAPIConfig();
        ret.setAppId(this.config.getAppId());
        ret.setNonce(nonce);
        ret.setTimestamp(timestamp);
        ret.setSignature(signature);
        return ret;
    }
}

