package net.sinodawn.data.mybatis;

import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

/**
 * @author liuxl
 */
public class MyBatisHelper {

    private static final SqlSessionFactory SQL_SESSION_FACTORY = Datasource.INSTANCE.getSqlSessionFactory();

    private static SqlSession sqlSession;

    private static void openSession() {
        if (null != sqlSession) {
            return;
        }
        sqlSession = SQL_SESSION_FACTORY.openSession();
    }

    /**
     * 获取sqlSession
     * @return sqlSession
     */
    public static SqlSession getSession() {
        openSession();
        return sqlSession;
    }

    public static void closeSession() {
        if (null == sqlSession) {
            return;
        }
        sqlSession.close();
        sqlSession = null;
    }
}
