package net.sinodawn.data.meta.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 数据库中表的基础关联信息
 * </p>
 *
 * @author liuxl
 * @since 2021-10-21
 */
@TableName("t_core_table")
@ApiModel(value = "CoreTable对象", description = "数据库中表的基础关联信息")
public class CoreTable implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("表名")
    private String id;

    @ApiModelProperty("是否是审核表")
    private String auditable;

    @ApiModelProperty("是否有附件")
    private String attachment;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getAuditable() {
        return auditable;
    }

    public void setAuditable(String auditable) {
        this.auditable = auditable;
    }
    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    @Override
    public String toString() {
        return "CoreTable{" +
            "id=" + id +
            ", auditable=" + auditable +
            ", attachment=" + attachment +
        "}";
    }
}
