package net.sinodawn.data;

import net.sinodawn.common.env.SinoPropertyResolver;
import net.sinodawn.common.exception.SinoGenericException;
import org.springframework.util.ObjectUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author admin@sinodawn.net
 */
public class DbType {

    private static DB DB_TYPE;

    public static DB getDb() {
        if (ObjectUtils.isEmpty(DB_TYPE)) {
            String url = SinoPropertyResolver.getInstance().getProperty("spring.datasource.url");
            String pattern = "(?!jdbc:(p6spy:)?)(mysql|dm|oracle)";
            Matcher matcher = Pattern.compile(pattern).matcher(url);
            if (matcher.find()) {
                switch (matcher.group()) {
                    case "mysql":
                        DB_TYPE = DB.MYSQL;
                        break;
                    case "dm":
                    case "oracle":
                        DB_TYPE = DB.ORACLE;
                        break;
                    default:
                        throw new SinoGenericException("数据库连接配置非法");
                }
            }
        }
        return DB_TYPE;
    }

    public enum DB {
        // mysql
        MYSQL("MySQL"),
        // oracle\dm
        ORACLE("Oracle");

        DB(String name) {
            this.name = name;
        }

        private final String name;

        public String getName() {
            return name;
        }

        public String getMapperLocation() {
            return "classpath*:/**/*" + getName() + "Mapper.xml";
        }
    }
}
