package net.sinodawn.data.mybatis.mapper;

import net.sinodawn.common.data.filter.SearchFilter;
import net.sinodawn.common.data.filter.SuffixParam;
import org.apache.commons.lang3.ArrayUtils;

import java.util.HashMap;

/**
 * mapper过滤条件
 * @author liuxl
 */
public class MapperParameter extends HashMap<String, Object> {

    public static final String SUFFIX_PARAM = "suffixParams";

    /**
     * 设置{@code MapperParameter} filter键值
     * @param filter {@code SearchFilter}实例
     */
    public void setFilter(SearchFilter filter) {
        // SECTION paramMap传值 [liuxl-20210923-1046]
        if (!filter.getParam().isEmpty()) {
            this.putAll(filter.getParam());
        }
        // !SECTION [liuxl-20210923-1046]

        // SECTION 设置suffixParams键值 [liuxl-20210923-1047]
        if (!filter.getFilterParams().isEmpty()) {
            SuffixParam[] suffixParams = (SuffixParam[]) this.get(SUFFIX_PARAM);
            if (suffixParams == null) {
                suffixParams = new SuffixParam[0];
            }
            this.put(SUFFIX_PARAM, ArrayUtils.addAll(suffixParams, filter.getFilterParams().toArray(new SuffixParam[0])));
        }
        // !SECTION [liuxl-20210923-1047]
    }

}
