/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.role.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.MaskImplementationException;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.dao.CoreRoleUserDao;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreRoleUserServiceImpl
implements CoreRoleUserService {
    @Autowired
    private CoreRoleUserDao roleUserDao;
    @Lazy
    @Autowired
    private CoreRoleService coreRoleService;
    @Lazy
    @Autowired
    private CoreUserService coreUserService;
    @Lazy
    @Autowired
    private CoreRoleUserService proxyInstance;

    @Override
    public CoreRoleUserDao getDao() {
        return this.roleUserDao;
    }

    @Override
    @Transactional
    @CacheEvict(value={"T_CORE_ROLE_USER.SOURCE_USER_ID"}, key="#userId")
    public Long insertByUserId(String userId, List<Long> roleIdList) {
        if (roleIdList.isEmpty()) {
            return null;
        }
        List insertRoleUserList = roleIdList.stream().map(r -> {
            CoreRoleUserBean roleUser = new CoreRoleUserBean();
            roleUser.setId(ApplicationContextHelper.getNextIdentity());
            roleUser.setRoleId((Long)r);
            roleUser.setUserId(userId);
            return roleUser;
        }).collect(Collectors.toList());
        this.getDao().insert(insertRoleUserList);
        return ((CoreRoleUserBean)insertRoleUserList.get(0)).getId();
    }

    @Override
    @Transactional
    @CacheEvict(value={"T_CORE_ROLE_USER.SOURCE_USER_ID"}, key="#userId")
    public void deleteByUserId(String userId, List<Long> roleIdList) {
        if (!roleIdList.isEmpty()) {
            CoreRoleUserBean filter = new CoreRoleUserBean();
            filter.setUserId(userId);
            List<CoreRoleUserBean> roleUserList = this.getDao().selectList(filter, new Order[0]);
            this.getDao().deleteByIdList(roleUserList.stream().filter(r -> roleIdList.contains(r.getRoleId())).map(CoreRoleUserBean::getId).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"T_CORE_ROLE_USER.SOURCE_USER_ID"}, key="#userId")
    public void deleteByUserId(String userId) {
        CoreRoleUserBean filter = new CoreRoleUserBean();
        filter.setUserId(userId);
        this.getDao().deleteBy(filter, "USERID");
    }

    @Override
    @Transactional
    public void deleteByRoleId(Long roleId) {
        CoreRoleUserBean filter = new CoreRoleUserBean();
        filter.setRoleId(roleId);
        List<CoreRoleUserBean> roleUserList = this.getDao().selectList(filter, new Order[0]);
        if (!roleUserList.isEmpty()) {
            roleUserList.forEach(r -> this.proxyInstance.deleteByUserId(r.getUserId(), Arrays.asList(r.getRoleId())));
        }
    }

    @Override
    @Cacheable(value={"T_CORE_ROLE_USER.SOURCE_USER_ID"}, key="#userId")
    public List<CoreRoleUserBean> selectByUserId(String userId) {
        CoreRoleUserBean filter = new CoreRoleUserBean();
        filter.setUserId(userId);
        return this.getDao().selectListByOneColumnValue(userId, "USERID", new Order[0]);
    }

    @Override
    public List<String> selectUserList(Long roleId) {
        CoreRoleUserBean filter = new CoreRoleUserBean();
        filter.setRoleId(roleId);
        return this.getDao().selectColumnList(filter, "USERID", String.class, new Order[0]);
    }

    @Override
    public Page<CoreRoleUserBean> selectPaginationByRole(Long roleId, RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        parameter.setFilter(SearchFilter.instance().match("ROLEID", roleId).filter(MatchPattern.EQ));
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long insert(RestJsonWrapperBean wrapper) {
        List<CoreRoleUserBean> roleUserList = wrapper.parse(CoreRoleUserBean.class);
        Map mapList = roleUserList.stream().collect(Collectors.groupingBy(CoreRoleUserBean::getUserId, Collectors.mapping(CoreRoleUserBean::getRoleId, Collectors.toList())));
        mapList.forEach((k, v) -> this.proxyInstance.insertByUserId((String)k, (List<Long>)v));
        return null;
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.UPDATE)
    @Audit(value="AUDIT.SAVE")
    @CacheEvict(value={"T_CORE_ROLE_USER.SOURCE_USER_ID"}, key="#userId")
    public void setDefault(String userId, RestJsonWrapperBean wrapper) {
        CoreRoleUserBean defaultRoleUser;
        ArrayList<CoreRoleUserBean> updateCoreRoleUserList = new ArrayList<CoreRoleUserBean>();
        List coreRoleUserList = this.selectListByFilter(SearchFilter.instance().match("USERID", userId).filter(MatchPattern.EQ).match("DEFAULTFLAG", "1").filter(MatchPattern.EQ), new Order[0]);
        if (!coreRoleUserList.isEmpty()) {
            defaultRoleUser = (CoreRoleUserBean)coreRoleUserList.get(0);
            defaultRoleUser.setDefaultFlag("0");
            updateCoreRoleUserList.add(defaultRoleUser);
        }
        defaultRoleUser = wrapper.parseUnique(CoreRoleUserBean.class);
        defaultRoleUser.setDefaultFlag("1");
        updateCoreRoleUserList.add(defaultRoleUser);
        this.getDao().update(updateCoreRoleUserList, new String[]{"DEFAULTFLAG"});
    }

    @Transactional
    public void save(List<Map<String, Object>> mapList) {
        mapList.forEach(m -> {
            String userId = (String)CollectionUtils.getValueIgnorecase(m, "id");
            String key = m.keySet().stream().filter(k -> k.startsWith("T_CORE_ROLE$ROLENAME$")).findAny().get();
            Long roleId = NumberUtils.parseLong(StringUtils.removeStart(key, "T_CORE_ROLE$ROLENAME$"));
            CoreRoleUserBean filter = new CoreRoleUserBean();
            filter.setUserId(userId);
            filter.setRoleId(roleId);
            CoreRoleUserBean roleUser = this.getDao().selectFirstIfPresent(filter, new Order[0]);
            if ("1".equals(m.get(key))) {
                if (roleUser == null) {
                    this.proxyInstance.insertByUserId(userId, Arrays.asList(roleId));
                }
            } else if (roleUser != null) {
                this.proxyInstance.deleteByUserId(userId, Arrays.asList(roleId));
            }
        });
    }

    @Override
    public void delete(Long id) {
        throw new MaskImplementationException();
    }

    @Override
    public void delete(RestJsonWrapperBean wrapper) {
        throw new MaskImplementationException();
    }

    @Override
    public void update(CoreRoleUserBean proxy) {
        throw new MaskImplementationException();
    }

    @Override
    public void updateIfChanged(List<CoreRoleUserBean> itemList) {
        throw new MaskImplementationException();
    }

    @Override
    public void updateIfChanged(CoreRoleUserBean item) {
        throw new MaskImplementationException();
    }

    @Override
    public void save(Long id, RestJsonWrapperBean wrapper) {
        throw new MaskImplementationException();
    }
}

