/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.role.service.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.page.PageRowBounds;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import net.sinodawn.framework.support.table.bean.TableHeadBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.bean.CoreRolePermissionBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.dao.CoreRoleDao;
import net.sinodawn.module.sys.role.service.CoreRolePermissionService;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreRoleServiceImpl
implements CoreRoleService {
    @Autowired
    private CoreRoleDao roleDao;
    @Autowired
    private CoreRoleUserService roleUserService;
    @Autowired
    private CoreRolePermissionService permissionService;

    @Override
    public CoreRoleDao getDao() {
        return this.roleDao;
    }

    @Override
    @Transactional
    public Long insert(RestJsonWrapperBean wrapper) {
        CoreRoleBean role = wrapper.parseUnique(CoreRoleBean.class);
        role.setId(ApplicationContextHelper.getNextIdentity());
        this.getDao().insert(role);
        return role.getId();
    }

    @Override
    public Page<CoreRoleUserBean> selectRoleUserPaginationByRole(Long roleId, RestJsonWrapperBean wrapper) {
        return this.roleUserService.selectPaginationByRole(roleId, wrapper);
    }

    @Override
    @Transactional
    public void insertRoleUser(Long id, RestJsonWrapperBean wrapper) {
        List<CoreRoleUserBean> roleUserList = wrapper.parse(CoreRoleUserBean.class);
        roleUserList.forEach(u -> this.roleUserService.insertByUserId(u.getUserId(), Arrays.asList(id)));
    }

    @Override
    @Transactional
    @Audit(value="AUDIT.DELETE")
    public void deleteRoleUser(RestJsonWrapperBean wrapper) {
        List<Long> roleUserIdList = wrapper.parseId(Long.class);
        List roleUserList = this.roleUserService.selectListByIds(roleUserIdList);
        Map mapList = roleUserList.stream().collect(Collectors.groupingBy(CoreRoleUserBean::getUserId, Collectors.mapping(CoreRoleUserBean::getRoleId, Collectors.toList())));
        mapList.forEach((k, v) -> this.roleUserService.deleteByUserId((String)k, (List<Long>)v));
    }

    @Override
    @Transactional
    public void insertRolePermission(Long id, String permissionTypeId, RestJsonWrapperBean wrapper) {
        List<CoreRolePermissionBean> permissionList = wrapper.parse(CoreRolePermissionBean.class);
        this.permissionService.insert(id, permissionTypeId, permissionList.stream().map(CoreRolePermissionBean::getTargetId).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    public void deleteRolePermission(Long id, String permissionTypeId, RestJsonWrapperBean wrapper) {
        List<CoreRolePermissionBean> permissionList = wrapper.parse(CoreRolePermissionBean.class);
        this.permissionService.delete(id, permissionTypeId, permissionList.stream().map(CoreRolePermissionBean::getTargetId).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    public void delete(RestJsonWrapperBean wrapper) {
        List<CoreRoleBean> roleList = wrapper.parse(CoreRoleBean.class);
        if (!roleList.isEmpty()) {
            roleList.forEach(r -> {
                this.roleUserService.deleteByRoleId(r.getId());
                this.permissionService.deleteByRoleId(r.getId());
            });
            CoreRoleService.super.delete(wrapper);
        }
    }

    public void doSuspendAction(RestJsonWrapperBean wrapper, boolean suspend) {
        List<CoreRoleBean> roleList = wrapper.parse(CoreRoleBean.class);
        if (!roleList.isEmpty()) {
            // empty if block
        }
    }

    public Page<CoreRoleBean> selectChoosablePagination(RestJsonWrapperBean wrapper) {
        MapperParameter parameter = wrapper.extractMapFilter();
        parameter.setSuspendedFlag("0");
        parameter.setOrgAuthority();
        PageRowBounds rowBounds = wrapper.extractPageRowBounds();
        return this.selectPagination(parameter, rowBounds);
    }

    @Override
    public boolean isPermissionTypeAdminRole(Long roleId, String permissionTypeId) {
        List<CoreRolePermissionBean> permissionList = this.permissionService.selectListByRole(roleId);
        return permissionList.stream().anyMatch(p -> permissionTypeId.equals(p.getPermissionTypeId()) && "0".equals(p.getTargetId()));
    }

    @Override
    public List<TableHeadBean> selectPermissionMatrixHeadList() {
        List roleList = this.getDao().selectAll();
        return roleList.stream().map(e -> {
            TableHeadBean head = new TableHeadBean();
            head.setTitle(e.getRoleName());
            head.setField(e.getId().toString());
            return head;
        }).collect(Collectors.toList());
    }

    @Override
    public RestValidationResultBean deleteValidate(RestJsonWrapperBean wrapper) {
        List<CoreRoleBean> roleList = wrapper.parse(CoreRoleBean.class);
        List roleIdList = roleList.stream().map(CoreRoleBean::getId).collect(Collectors.toList());
        List roleUserList = this.roleUserService.getDao().selectListByOneColumnValues(roleIdList, "ROLEID", new Order[0]);
        List rolePermissionList = this.permissionService.getDao().selectListByOneColumnValues(roleIdList, "ROLEID", new Order[0]);
        boolean validateFlag = true;
        StringBuilder messageBuilder = new StringBuilder();
        Iterator<CoreRoleBean> var8 = roleList.iterator();
        while (var8.hasNext()) {
            CoreRoleBean role;
            CoreRoleBean finalRole = role = var8.next();
            List subRoleUserList = roleUserList.stream().filter(f -> f.getRoleId().equals(finalRole.getId())).collect(Collectors.toList());
            CoreRoleBean finalRole1 = role;
            List subRolePermissionList = rolePermissionList.stream().filter(f -> f.getRoleId().equals(finalRole1.getId())).collect(Collectors.toList());
            if (subRoleUserList.isEmpty() && subRolePermissionList.isEmpty()) continue;
            validateFlag = false;
            messageBuilder.append(role.getRoleName() + ":");
            if (!subRoleUserList.isEmpty() && subRolePermissionList.isEmpty()) {
                messageBuilder.append(I18nHelper.getMessage("MODULE.SYS.ROLES.TIP.EXISTS_ROLE_USERS", new String[0]));
            } else if (subRoleUserList.isEmpty() && !subRolePermissionList.isEmpty()) {
                messageBuilder.append(I18nHelper.getMessage("MODULE.SYS.ROLES.TIP.EXISTS_ROLE_PERMISSIONS", new String[0]));
            } else {
                messageBuilder.append(I18nHelper.getMessage("MODULE.SYS.ROLES.TIP.EXISTS_ROLE_USERS_AND_PERMISSIONS", new String[0]));
            }
            messageBuilder.append("<br />");
        }
        return new RestValidationResultBean(validateFlag, messageBuilder.toString());
    }
}

