/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.role.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.MaskImplementationException;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.bean.CoreRolePermissionBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.dao.CoreRolePermissionDao;
import net.sinodawn.module.sys.role.service.CoreRolePermissionService;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreRolePermissionServiceImpl
implements CoreRolePermissionService {
    @Autowired
    private CoreRolePermissionDao permissionDao;
    @Lazy
    @Autowired
    private CoreRoleUserService roleUserService;
    @Lazy
    @Autowired
    private CoreRoleService roleService;
    @Lazy
    @Autowired
    private CoreRolePermissionService proxyInstance;

    @Override
    public CoreRolePermissionDao getDao() {
        return this.permissionDao;
    }

    @Override
    @Transactional
    public Long insert(RestJsonWrapperBean wrapper) {
        List<CoreRolePermissionBean> rolePermissionList = wrapper.parse(CoreRolePermissionBean.class);
        if (!rolePermissionList.isEmpty()) {
            Map<Long, List<CoreRolePermissionBean>> map = rolePermissionList.stream().collect(Collectors.groupingBy(CoreRolePermissionBean::getRoleId));
            map.forEach((r, m) -> {
                Map<String, ArrayList> targetMap = m.stream().collect(Collectors.toMap(CoreRolePermissionBean::getPermissionTypeId, x -> new ArrayList<String>(Collections.singletonList(x.getTargetId())), (o1List, o2List) -> {
                    o1List.addAll(o2List);
                    return o1List;
                }));
                targetMap.forEach((p, t) -> this.proxyInstance.insert((Long)r, (String)p, (List<String>)t));
            });
        }
        return null;
    }

    @Override
    @Transactional
    @CacheEvict(value={"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"}, key="'' + #roleId")
    public void insert(Long roleId, String permissionTypeId, List<String> targetIdList) {
        Set permissionIdSet = this.proxyInstance.selectListByRole(roleId).stream().filter(p -> permissionTypeId.equals(p.getPermissionTypeId())).map(CoreRolePermissionBean::getTargetId).collect(Collectors.toSet());
        List insertPermissionList = targetIdList.stream().filter(t -> !permissionIdSet.contains(t)).map(t -> {
            CoreRolePermissionBean permission = new CoreRolePermissionBean();
            permission.setId(ApplicationContextHelper.getNextIdentity());
            permission.setRoleId(roleId);
            permission.setPermissionTypeId(permissionTypeId);
            permission.setTargetId((String)t);
            return permission;
        }).collect(Collectors.toList());
        this.getDao().insert(insertPermissionList);
    }

    @Override
    @Transactional
    public void delete(RestJsonWrapperBean wrapper) {
        List<Long> idList = wrapper.parseId(Long.class);
        if (!idList.isEmpty()) {
            List rolePermissionList = this.getDao().selectListByIds(idList, new Order[0]);
            Map<Long, List<CoreRolePermissionBean>> map = rolePermissionList.stream().collect(Collectors.groupingBy(CoreRolePermissionBean::getRoleId));
            map.forEach((r, m) -> {
                Map<String, ArrayList> targetMap = m.stream().collect(Collectors.toMap(CoreRolePermissionBean::getPermissionTypeId, x -> new ArrayList<String>(Collections.singletonList(x.getTargetId())), (o1List, o2List) -> {
                    o1List.addAll(o2List);
                    return o1List;
                }));
                targetMap.forEach((p, t) -> this.proxyInstance.delete((Long)r, (String)p, (List<String>)t));
            });
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"}, key="'' + #roleId")
    public void delete(Long roleId, String permissionTypeId, List<String> targetIdList) {
        List deletePermissionList = targetIdList.stream().map(t -> {
            CoreRolePermissionBean permission = new CoreRolePermissionBean();
            permission.setRoleId(roleId);
            permission.setPermissionTypeId(permissionTypeId);
            permission.setTargetId((String)t);
            return permission;
        }).collect(Collectors.toList());
        this.getDao().deleteBy(deletePermissionList, new String[]{"ROLEID", "TARGETID", "PERMISSIONTYPEID"});
    }

    @Override
    @Transactional
    @CacheEvict(value={"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"}, key="'' + #roleId")
    public void deleteByRoleId(Long roleId) {
        CoreRolePermissionBean filter = new CoreRolePermissionBean();
        filter.setRoleId(roleId);
        this.getDao().deleteBy(filter, "ROLEID");
    }

    @Override
    @Cacheable(value={"T_CORE_ROLE_PERMISSION.SOURCE_ROLEID"}, key="'' + #roleId")
    public List<CoreRolePermissionBean> selectListByRole(Long roleId) {
        CoreRolePermissionBean filter = new CoreRolePermissionBean();
        filter.setRoleId(roleId);
        return this.getDao().selectList(filter, new Order[0]);
    }

    @Override
    public List<CoreRolePermissionBean> selectActiveUserPermissionList(String userId, String permissionType) {
        List<CoreRoleUserBean> roleUserList = this.roleUserService.selectByUserId(userId);
        ArrayList<CoreRolePermissionBean> rolePermissionList = new ArrayList<CoreRolePermissionBean>();
        for (CoreRoleUserBean roleUser : roleUserList) {
            CoreRoleBean role = (CoreRoleBean)this.roleService.selectByIdIfPresent(roleUser.getRoleId());
            if (role == null || !"0".equals(role.getLastSuspendedFlag())) continue;
            List<CoreRolePermissionBean> allPermissionList = this.proxyInstance.selectListByRole(role.getId());
            rolePermissionList.addAll(allPermissionList.stream().filter(p -> permissionType.equals(p.getPermissionTypeId())).collect(Collectors.toList()));
        }
        return rolePermissionList;
    }

    @Override
    public String selectPermissionTypeAdmin(String permisionTypeId) {
        List<CoreRoleUserBean> roleUserList = this.roleUserService.selectByUserId(LocalContextHelper.getLoginUserId());
        for (CoreRoleUserBean roleUser : roleUserList) {
            List<CoreRolePermissionBean> allPermissionList;
            CoreRoleBean role = (CoreRoleBean)this.roleService.selectByIdIfPresent(roleUser.getRoleId());
            if (role == null || !(allPermissionList = this.proxyInstance.selectListByRole(role.getId())).stream().anyMatch(p -> p.getPermissionTypeId().equals(permisionTypeId) && "0".equals(p.getTargetId()))) continue;
            return "1";
        }
        return "0";
    }

    @Override
    public void delete(Long id) {
        throw new MaskImplementationException();
    }

    @Override
    public void update(CoreRolePermissionBean proxy) {
        throw new MaskImplementationException();
    }

    @Override
    public void updateIfChanged(List<CoreRolePermissionBean> itemList) {
        throw new MaskImplementationException();
    }

    @Override
    public void updateIfChanged(CoreRolePermissionBean item) {
        throw new MaskImplementationException();
    }

    @Override
    public void save(Long id, RestJsonWrapperBean wrapper) {
        throw new MaskImplementationException();
    }
}

