/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.password.service.impl;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.PasswordException;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.EncryptUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.sys.password.bean.CorePasswordHisBean;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.password.dao.CorePasswordPolicyDao;
import net.sinodawn.module.sys.password.service.CorePasswordHisService;
import net.sinodawn.module.sys.password.service.CorePasswordPolicyService;
import net.sinodawn.module.sys.role.bean.CoreRoleBean;
import net.sinodawn.module.sys.role.bean.CoreRoleUserBean;
import net.sinodawn.module.sys.role.service.CoreRolePermissionService;
import net.sinodawn.module.sys.role.service.CoreRoleService;
import net.sinodawn.module.sys.role.service.CoreRoleUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CorePasswordPolicyServiceImpl
implements CorePasswordPolicyService {
    @Autowired
    private CorePasswordPolicyDao policyDao;
    @Autowired
    @Lazy
    private CoreRoleUserService roleUserService;
    @Autowired
    @Lazy
    private CoreRolePermissionService rolePermissionService;
    @Autowired
    @Lazy
    private CoreRoleService roleService;
    @Autowired
    private CorePasswordHisService hisService;

    @Override
    public CorePasswordPolicyDao getDao() {
        return this.policyDao;
    }

    @Override
    @Transactional
    public Long insert(RestJsonWrapperBean jsonWrapper) {
        CorePasswordPolicyBean policy = jsonWrapper.parseUnique(CorePasswordPolicyBean.class);
        policy.setId(ApplicationContextHelper.getNextIdentity());
        policy.setType("ROLE");
        this.getDao().insert(policy);
        return policy.getId();
    }

    @Override
    public List<CorePasswordPolicyBean> selectEffectedList(String userId) {
        List roleList;
        List<Long> idList;
        ArrayList<CorePasswordPolicyBean> effectedList = new ArrayList<CorePasswordPolicyBean>();
        List<CoreRoleUserBean> roleUserList = this.roleUserService.selectByUserId(userId);
        if (!roleUserList.isEmpty() && !(idList = (roleList = roleUserList.stream().map(u -> (CoreRoleBean)this.roleService.selectById(u.getRoleId())).collect(Collectors.toList())).stream().filter(r -> "0".equals(r.getLastSuspendedFlag()) && r.getPasswordPolicyId() != null).map(r -> r.getPasswordPolicyId()).collect(Collectors.toList())).isEmpty()) {
            idList.forEach(i -> {
                CorePasswordPolicyBean policy = (CorePasswordPolicyBean)this.getDao().selectByIdIfPresent(i);
                if (policy != null) {
                    effectedList.add(policy);
                }
            });
        }
        if (effectedList.isEmpty()) {
            effectedList.add((CorePasswordPolicyBean)this.getDao().selectById(1L));
        }
        return effectedList;
    }

    @Override
    public void checkPassword(String userId, String rawPassword) {
        List<CorePasswordPolicyBean> policyList = this.selectEffectedList(userId);
        if (!policyList.isEmpty()) {
            CorePasswordPolicyBean policy;
            CorePasswordHisBean hisFilter = new CorePasswordHisBean();
            hisFilter.setUserId(userId);
            List<CorePasswordHisBean> hisList = this.hisService.selectList(hisFilter, Order.desc("ID"));
            LocalDateTime now = LocalDateTime.now();
            Iterator<CorePasswordPolicyBean> var7 = policyList.iterator();
            while (true) {
                CorePasswordHisBean passwordHis;
                int count;
                if (!var7.hasNext()) {
                    return;
                }
                policy = var7.next();
                StringBuilder sb = new StringBuilder();
                if (policy.getMinNumber() != null && !rawPassword.matches(".*(\\d{1}\\D*){" + policy.getMinNumber() + ",}.*")) {
                    sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.MIN_NUMBER_REQUIRED", new String[0])).append(":").append(policy.getMinNumber());
                }
                if (policy.getMinLowercase() != null && !rawPassword.matches(".*([a-z]{1}[^a-z]*){" + policy.getMinLowercase() + ",}.*")) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.MIN_LOWERCASE_REQUIRED", new String[0])).append(":").append(policy.getMinLowercase());
                }
                if (policy.getMinUppercase() != null && !rawPassword.matches(".*([A-Z]{1}[^A-Z]*){" + policy.getMinUppercase() + ",}.*")) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.MIN_UPPERCASE_REQUIRED", new String[0])).append(":").append(policy.getMinUppercase());
                }
                if (policy.getMinSpecialCharacters() != null && !rawPassword.matches(".*([^A-Za-z0-9]{1}[A-Za-z0-9]*){" + policy.getMinSpecialCharacters() + ",}.*")) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.MIN_SPECIALCHARACTERS_REQUIRED", new String[0])).append(":").append(policy.getMinSpecialCharacters());
                }
                if (policy.getMinLength() != null && (long)rawPassword.length() < policy.getMinLength()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.MIN_LENGTH", new String[0])).append(":").append(policy.getMinLength());
                }
                if (policy.getMaxLength() != null && (long)rawPassword.length() > policy.getMaxLength()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.MAX_LENGTH", new String[0])).append(":").append(policy.getMaxLength());
                }
                if (policy.getComposition() != null && policy.getComposition() > 0L) {
                    count = 0;
                    if (StringUtils.containsNumber(rawPassword)) {
                        ++count;
                    }
                    if (StringUtils.containsLowercaseLetter(rawPassword)) {
                        ++count;
                    }
                    if (StringUtils.containsCapitalLetter(rawPassword)) {
                        ++count;
                    }
                    if (StringUtils.containsSpecialCharacter(rawPassword)) {
                        ++count;
                    }
                    if (policy.getComposition() > (long)count) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(I18nHelper.getMessage("SINO.USER.PASSWORD.COMPOSITION", new String[0])).append(":").append(policy.getComposition());
                    }
                }
                if (sb.length() > 0) {
                    throw new PasswordException(sb.toString());
                }
                if (hisList.isEmpty()) continue;
                if (policy.getReuseInterval() != null && (passwordHis = (CorePasswordHisBean)hisList.stream().filter(h -> h.getPassword().equals(EncryptUtils.MD5Encrypt(rawPassword))).findFirst().orElse(null)) != null && passwordHis.getCreatedTime().plusDays(policy.getReuseInterval()).isAfter(now)) {
                    throw new PasswordException(I18nHelper.getMessage("SINO.USER.PASSWORD.REUSE_PASSWORD_INTERVAL", new String[0]) + ":" + policy.getReuseInterval());
                }
                if (policy.getHistoryLength() == null) continue;
                count = 0;
                for (CorePasswordHisBean passwordHis2 : hisList) {
                    if (passwordHis2.getPassword().equals(EncryptUtils.MD5Encrypt(rawPassword))) break;
                    ++count;
                }
                if ((long)count < policy.getHistoryLength()) break;
            }
            throw new PasswordException(I18nHelper.getMessage("SINO.USER.PASSWORD.REUSE_PASSWORD_HISTORY_LENGTH", new String[0]) + ":" + policy.getHistoryLength());
        }
    }

    @Override
    public CorePasswordPolicyBean selectMatchingPasswordPolicy() {
        String userId = LocalContextHelper.getLoginUserId();
        return this.selectMatchingPasswordPolicy(userId);
    }

    @Override
    public CorePasswordPolicyBean selectMatchingPasswordPolicy(String userId) {
        List<CorePasswordPolicyBean> passwordPolicyList = this.selectEffectedList(userId);
        if (passwordPolicyList.isEmpty()) {
            return null;
        }
        CorePasswordPolicyBean matchingPasswordPolicy = new CorePasswordPolicyBean();
        int j = passwordPolicyList.size();
        for (int i = 0; i < j; ++i) {
            CorePasswordPolicyBean passwordPolicy = passwordPolicyList.get(i);
            matchingPasswordPolicy.setMinNumber(NumberUtils.max(matchingPasswordPolicy.getMinNumber(), passwordPolicy.getMinNumber()));
            matchingPasswordPolicy.setMinLowercase(NumberUtils.max(matchingPasswordPolicy.getMinLowercase(), passwordPolicy.getMinLowercase()));
            matchingPasswordPolicy.setMinUppercase(NumberUtils.max(matchingPasswordPolicy.getMinUppercase(), passwordPolicy.getMinUppercase()));
            matchingPasswordPolicy.setMinSpecialCharacters(NumberUtils.max(matchingPasswordPolicy.getMinSpecialCharacters(), passwordPolicy.getMinSpecialCharacters()));
            matchingPasswordPolicy.setMinLength(NumberUtils.max(matchingPasswordPolicy.getMinLength(), passwordPolicy.getMinLength()));
            matchingPasswordPolicy.setMaxLength(NumberUtils.min(matchingPasswordPolicy.getMaxLength(), passwordPolicy.getMaxLength()));
            matchingPasswordPolicy.setComposition(NumberUtils.max(matchingPasswordPolicy.getComposition(), passwordPolicy.getComposition()));
            matchingPasswordPolicy.setMaxFailedAttempts(NumberUtils.min(matchingPasswordPolicy.getMaxFailedAttempts(), passwordPolicy.getMaxFailedAttempts()));
            matchingPasswordPolicy.setExpiryInterval(NumberUtils.min(matchingPasswordPolicy.getExpiryInterval(), passwordPolicy.getExpiryInterval()));
            matchingPasswordPolicy.setExpiryWarningInterval(NumberUtils.max(matchingPasswordPolicy.getExpiryWarningInterval(), passwordPolicy.getExpiryWarningInterval()));
            matchingPasswordPolicy.setExpiredMaxUse(NumberUtils.min(matchingPasswordPolicy.getExpiredMaxUse(), passwordPolicy.getExpiredMaxUse()));
            matchingPasswordPolicy.setReuseInterval(NumberUtils.min(matchingPasswordPolicy.getReuseInterval(), passwordPolicy.getReuseInterval()));
            matchingPasswordPolicy.setHistoryLength(NumberUtils.max(matchingPasswordPolicy.getHistoryLength(), passwordPolicy.getHistoryLength()));
        }
        if (matchingPasswordPolicy.getMinNumber() != null && matchingPasswordPolicy.getMinNumber() == 0L) {
            matchingPasswordPolicy.setMinNumber(null);
        }
        if (matchingPasswordPolicy.getMinLowercase() != null && matchingPasswordPolicy.getMinLowercase() == 0L) {
            matchingPasswordPolicy.setMinLowercase(null);
        }
        if (matchingPasswordPolicy.getMinUppercase() != null && matchingPasswordPolicy.getMinUppercase() == 0L) {
            matchingPasswordPolicy.setMinUppercase(null);
        }
        if (matchingPasswordPolicy.getMinSpecialCharacters() != null && matchingPasswordPolicy.getMinSpecialCharacters() == 0L) {
            matchingPasswordPolicy.setMinSpecialCharacters(null);
        }
        if (matchingPasswordPolicy.getMinLength() != null && matchingPasswordPolicy.getMinLength() == 0L) {
            matchingPasswordPolicy.setMinLength(null);
        }
        if (matchingPasswordPolicy.getMaxLength() != null && matchingPasswordPolicy.getMaxLength() == 0L) {
            matchingPasswordPolicy.setMaxLength(null);
        }
        if (matchingPasswordPolicy.getComposition() != null && matchingPasswordPolicy.getComposition() == 0L) {
            matchingPasswordPolicy.setComposition(null);
        }
        if (matchingPasswordPolicy.getMaxFailedAttempts() != null && matchingPasswordPolicy.getMaxFailedAttempts() == 0L) {
            matchingPasswordPolicy.setMaxFailedAttempts(null);
        }
        if (matchingPasswordPolicy.getExpiryInterval() != null && matchingPasswordPolicy.getExpiryInterval() == 0L) {
            matchingPasswordPolicy.setExpiryInterval(null);
        }
        if (matchingPasswordPolicy.getExpiryWarningInterval() != null && matchingPasswordPolicy.getExpiryWarningInterval() == 0L) {
            matchingPasswordPolicy.setExpiryWarningInterval(null);
        }
        if (matchingPasswordPolicy.getExpiredMaxUse() != null && matchingPasswordPolicy.getExpiredMaxUse() == 0L) {
            matchingPasswordPolicy.setExpiredMaxUse(null);
        }
        if (matchingPasswordPolicy.getReuseInterval() != null && matchingPasswordPolicy.getReuseInterval() == 0L) {
            matchingPasswordPolicy.setReuseInterval(null);
        }
        if (matchingPasswordPolicy.getHistoryLength() != null && matchingPasswordPolicy.getHistoryLength() == 0L) {
            matchingPasswordPolicy.setHistoryLength(null);
        }
        return matchingPasswordPolicy;
    }

    @Override
    public Long selectPasswordExpireRemainingDays() {
        CoreUserBean loginUser = LocalContextHelper.getLoginUser();
        List<CorePasswordPolicyBean> passwordPolicyList = this.selectEffectedList(loginUser.getId());
        return this.selectPasswordExpireRemainingDays(passwordPolicyList);
    }

    @Override
    public Long selectPasswordExpireRemainingDays(List<CorePasswordPolicyBean> passwordPolicyList) {
        CoreUserBean loginUser = LocalContextHelper.getLoginUser();
        List expiryWarningIntervalPasswordPolicyList = passwordPolicyList.stream().filter(p -> p.getExpiryInterval() != null && p.getExpiryInterval() > 0L && p.getExpiryWarningInterval() != null && p.getExpiryWarningInterval() > 0L).collect(Collectors.toList());
        if (!expiryWarningIntervalPasswordPolicyList.isEmpty()) {
            LocalDateTime now = LocalDateTime.now();
            ArrayList<Long> passwordExpireRemainingDaysList = new ArrayList<Long>();
            for (CorePasswordPolicyBean passwordPolicy : expiryWarningIntervalPasswordPolicyList) {
                if (!loginUser.getPasswordUpdatedTime().plusDays(passwordPolicy.getExpiryInterval() - passwordPolicy.getExpiryWarningInterval()).isBefore(now)) continue;
                long passwordExpireRemainingDays = Duration.between(now, loginUser.getPasswordUpdatedTime().plusDays(passwordPolicy.getExpiryInterval())).toDays();
                passwordExpireRemainingDaysList.add(passwordExpireRemainingDays);
            }
            if (passwordExpireRemainingDaysList.isEmpty()) {
                return null;
            }
            return passwordExpireRemainingDaysList.stream().mapToLong(e -> e).min().getAsLong();
        }
        return null;
    }

    @Override
    public Long selectPasswordExpiredMaxUse(List<CorePasswordPolicyBean> passwordPolicyList) {
        List expiredMaxUsePasswordPolicyList = passwordPolicyList.stream().filter(p -> p.getExpiredMaxUse() != null && p.getExpiredMaxUse() > 0L).collect(Collectors.toList());
        return !expiredMaxUsePasswordPolicyList.isEmpty() ? Long.valueOf(expiredMaxUsePasswordPolicyList.stream().mapToLong(e -> e.getExpiredMaxUse()).min().getAsLong()) : null;
    }
}

