/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.metadata.service.impl;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.metadata.bean.CoreValidatorBean;
import net.sinodawn.module.sys.metadata.dao.CoreValidatorDao;
import net.sinodawn.module.sys.metadata.service.CoreValidatorService;
import net.sinodawn.module.sys.metadata.support.ValidatorType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CoreValidatorServiceImpl
implements CoreValidatorService {
    @Autowired
    private CoreValidatorDao validatorDao;

    @Override
    public List<CoreValidatorBean> selectEnabledValidatorByTable(String table) {
        return this.validatorDao.selectEnabledValidatorByTable(table);
    }

    @Override
    public <T extends Persistable<?>> List<String> validate(T item) {
        if (item == null) {
            return CollectionUtils.emptyList();
        }
        String table = PersistableMetadataHelper.getTableName(item.getClass());
        List<CoreValidatorBean> validatorList = this.selectEnabledValidatorByTable(table);
        return validatorList.isEmpty() ? CollectionUtils.emptyList() : validatorList.stream().map(v -> this.validate((CoreValidatorBean)v, item)).filter(s -> !StringUtils.isEmpty(s)).collect(Collectors.toList());
    }

    private <T extends Persistable<?>> String validate(CoreValidatorBean validator, T item) {
        if (validator.getTypeName().equalsIgnoreCase(ValidatorType.STRING.name())) {
            String value = ConvertUtils.convert(PersistableHelper.getPropertyValue(item, validator.getColumnName()), String.class);
            if (!(value != null || Integer.valueOf(1).equals(validator.getNullable()) && validator.getMinSize() <= 0)) {
                return validator.getMessage();
            }
            if (value != null && (value.length() < validator.getMinSize() || value.length() > validator.getMaxSize())) {
                return validator.getMessage();
            }
        } else if (validator.getTypeName().equalsIgnoreCase(ValidatorType.NUMBER.name())) {
            Double value = ConvertUtils.convert(PersistableHelper.getPropertyValue(item, validator.getColumnName()), Double.class);
            if (value == null && !Integer.valueOf(1).equals(validator.getNullable())) {
                return validator.getMessage();
            }
            if (value != null && (value < (double)validator.getMin().intValue() || value > (double)validator.getMax().intValue())) {
                return validator.getMessage();
            }
        } else {
            if (!validator.getTypeName().equalsIgnoreCase(ValidatorType.DATE.name())) {
                throw new UnsupportedException("Type name [" + validator.getTypeName() + "] is not supported!");
            }
            LocalDateTime value = ConvertUtils.convert(PersistableHelper.getPropertyValue(item, validator.getColumnName()), LocalDateTime.class);
            if (value == null && !"1".equals(validator.getNullable())) {
                return validator.getMessage();
            }
            if (value != null) {
                String past;
                String future = validator.getFuture();
                if (!StringUtils.isEmpty(future)) {
                    LocalDateTime futureValue;
                    if ("now".equals(future) && value.isAfter(LocalDateTime.now())) {
                        return validator.getMessage();
                    }
                    if (!"now".equals(future) && (futureValue = ConvertUtils.convert(PersistableHelper.getPropertyValue(item, future), LocalDateTime.class)) != null && value.isAfter(futureValue)) {
                        return validator.getMessage();
                    }
                }
                if (!StringUtils.isEmpty(past = validator.getPast())) {
                    LocalDateTime pastValue;
                    if ("now".equals(past) && value.isBefore(LocalDateTime.now())) {
                        return validator.getMessage();
                    }
                    if (!"now".equals(past) && (pastValue = ConvertUtils.convert(PersistableHelper.getPropertyValue(item, past), LocalDateTime.class)) != null && value.isBefore(pastValue)) {
                        return validator.getMessage();
                    }
                }
            }
        }
        return null;
    }
}

