/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.metadata.service.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.AuditTrailHelper;
import net.sinodawn.framework.at.aspect.AuditTrailAspect;
import net.sinodawn.framework.audit.AuditDatabaseOperation;
import net.sinodawn.framework.context.SinoBeanContext;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.data.page.Pagination;
import net.sinodawn.framework.database.context.ColumnContext;
import net.sinodawn.framework.database.context.EntityColumnContext;
import net.sinodawn.framework.database.context.EntityContext;
import net.sinodawn.framework.database.core.DatabaseManager;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.database.sql.SqlType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnCommentBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnTargetService;
import net.sinodawn.module.sys.metadata.bean.CoreParentTableInstanceDTO;
import net.sinodawn.module.sys.metadata.bean.CoreTableBean;
import net.sinodawn.module.sys.metadata.bean.CoreTableHierarchyBean;
import net.sinodawn.module.sys.metadata.bean.CoreTablePermissionBean;
import net.sinodawn.module.sys.metadata.dao.CoreTableDao;
import net.sinodawn.module.sys.metadata.dao.CoreTableHierarchyDao;
import net.sinodawn.module.sys.metadata.dao.CoreTablePermissionDao;
import net.sinodawn.module.sys.metadata.mapper.CoreMetadataMapper;
import net.sinodawn.module.sys.metadata.service.CoreTableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreTableServiceImpl
implements CoreTableService {
    @Autowired
    private CoreTableDao tableDao;
    @Autowired
    private CoreTableHierarchyDao tableHierarchyDao;
    @Autowired
    private CoreTablePermissionDao tablePermissionDao;
    @Autowired
    private CoreFileService fileService;
    @Autowired
    private CoreMetadataMapper metadataMapper;
    @Autowired
    @Lazy
    private CoreTableService proxyInstance;
    @Autowired
    private CoreBpmnCommentService commentService;
    @Autowired
    private CoreBpmnTargetService bpmnTargetService;

    @Override
    public CoreTableDao getDao() {
        return this.tableDao;
    }

    @Override
    public List<CoreParentTableInstanceDTO> selectAncientTableInstanceList(String table, List<? extends Serializable> idList) {
        return this.selectAncientList(table, idList.stream().map(i -> Pair.of(i, ConvertUtils.convert(i, String.class))).collect(Collectors.toList()));
    }

    @Override
    public Map<? extends Serializable, String> selectMasterMap(CoreTableHierarchyBean tableHierarchy, List<? extends Serializable> idList) {
        if (idList.isEmpty()) {
            return CollectionUtils.emptyMap();
        }
        List<Map<String, Object>> mapList = this.metadataMapper.selectMasterMap(tableHierarchy.getTableName(), tableHierarchy.getReferColumn(), idList);
        return mapList.stream().collect(Collectors.toMap(m -> (Serializable)CollectionUtils.getValueIgnorecase(m, "ID"), m -> ObjectUtils.toString(CollectionUtils.getValueIgnorecase(m, "MASTERID"))));
    }

    @Override
    @Transactional
    public <ID extends Serializable> void deleteCascade(String table, ID id) {
        Object dao;
        CoreTableBean coreTable;
        List<CoreTableHierarchyBean> tableHierarchyList;
        List<Object> childIdList;
        AuditTrailAspect.AuditTrailEntryData auditTrailEntryData;
        table = table.toUpperCase();
        if (AuditTrailHelper.auditTrail() && AuditTrailHelper.auditTrailable(table, AuditDatabaseOperation.DELETE) && (auditTrailEntryData = AuditTrailAspect.getAuditTrailEntryData()) != null) {
            Object service = SinoBeanContext.getServiceByTable(table);
            EntityContext entityContext = service.getDao().getEntityContext();
            Object item = service.selectById((Serializable)((Serializable)ConvertUtils.convert(id, entityContext.getIdContext().getType())));
            childIdList = entityContext.getColumnContextList();
            String targetId = AuditTrailAspect.getAncientTargetId(table, id);
            for (EntityColumnContext entityColumnContext : childIdList) {
                if (!AuditTrailHelper.auditTrailableColumn(table, entityColumnContext.getColumnName())) continue;
                CoreAuditTrailRecordLineBean line = new CoreAuditTrailRecordLineBean();
                line.setRecordType(SqlType.DELETE.name());
                line.setTargetId(table + "$" + id);
                line.setTableName(table);
                line.setColumn(entityColumnContext.getColumnName().toUpperCase());
                line.setOldValue(ObjectUtils.toString(entityColumnContext.getValue(item)));
                AuditTrailAspect.addRecordLine(targetId, line);
            }
        }
        if (!(tableHierarchyList = this.proxyInstance.selectTableHierarchyByMaster(table)).isEmpty()) {
            for (CoreTableHierarchyBean tableHierarchy : tableHierarchyList) {
                CoreTableBean coreTable2 = this.proxyInstance.selectTable(tableHierarchy.getTableName());
                childIdList = this.metadataMapper.selectIdByMaster(coreTable2.getId(), tableHierarchy.getReferColumn(), id);
                for (String string : childIdList) {
                    this.deleteCascade(coreTable2.getId(), string);
                }
            }
        }
        if ((coreTable = this.proxyInstance.selectTable(table)) != null) {
            if ("1".equals(coreTable.getAuditable())) {
                CoreBpmnCommentBean filter = new CoreBpmnCommentBean();
                filter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
                this.commentService.getDao().deleteBy((List)((List)((Object)filter)), new String[]{"TARGETID"});
                this.bpmnTargetService.delete(filter.getTargetId());
            }
            if ("1".equals(coreTable.getAttachment())) {
                this.fileService.delete(coreTable.getId(), id);
            }
        }
        if ((dao = SinoBeanContext.getServiceByTable(table).getDao()) != null) {
            Object convertId = ConvertUtils.convert(id, dao.getEntityContext().getIdContext().getType());
            Class<?> daoClazz = ClassUtils.getRawType(dao.getClass());
            Method method = ReflectionUtils.findMethodByName(daoClazz, "delete");
            ReflectionUtils.invokeMethod(method, dao, convertId);
        }
    }

    @Override
    public List<CoreTableHierarchyBean> selectTableHierarchyByMaster(String masterTable) {
        CoreTableHierarchyBean terms = new CoreTableHierarchyBean();
        terms.setMasterTableName(masterTable);
        return this.tableHierarchyDao.selectList(terms, Order.desc("ID"));
    }

    @Override
    public List<CoreTableHierarchyBean> selectTableHierarchy(String table) {
        CoreTableHierarchyBean filter = new CoreTableHierarchyBean();
        filter.setTableName(table);
        return this.tableHierarchyDao.selectList(filter, new Order[0]);
    }

    @Override
    public <ID> CoreTableHierarchyBean selectTableHierarchy(String table, ID id) {
        CoreTableHierarchyBean tableHierarchy;
        List<CoreTableHierarchyBean> tableHierarchyList = this.proxyInstance.selectTableHierarchy(table);
        if (tableHierarchyList.isEmpty()) {
            return null;
        }
        if (tableHierarchyList.size() == 1) {
            return tableHierarchyList.get(0);
        }
        Iterator<CoreTableHierarchyBean> var4 = tableHierarchyList.iterator();
        do {
            if (var4.hasNext()) continue;
            return null;
        } while (this.metadataMapper.countMaster((tableHierarchy = var4.next()).getTableName(), tableHierarchy.getMasterTableName(), tableHierarchy.getReferColumn(), id) <= 0L);
        return tableHierarchy;
    }

    @Override
    public CoreTablePermissionBean selectTablePermission(String table, String category) {
        CoreTablePermissionBean tablePermission = new CoreTablePermissionBean();
        tablePermission.setTableName(table);
        tablePermission.setCategory(category);
        return this.tablePermissionDao.selectOneIfPresent(tablePermission, new String[0]);
    }

    @Override
    public CoreTableBean selectTable(String table) {
        return (CoreTableBean)this.getDao().selectByIdIfPresent(table);
    }

    @Override
    public Page<ColumnContext> selectTableColumnList(String table, RestJsonWrapperBean wrapper) {
        return new Pagination<ColumnContext>(DatabaseManager.getTableColumnContextList(table));
    }

    private List<CoreParentTableInstanceDTO> selectAncientList(String table, List<Pair<?, String>> pairList) {
        CoreTableHierarchyBean tableHierarchy = this.proxyInstance.selectTableHierarchy(table, pairList.get(0).getSecond());
        if (tableHierarchy == null) {
            ArrayList<CoreParentTableInstanceDTO> instanceList = new ArrayList<CoreParentTableInstanceDTO>();
            pairList.forEach(p -> {
                CoreParentTableInstanceDTO instance = new CoreParentTableInstanceDTO();
                instance.setSourceId(ConvertUtils.convert(p.getFirst(), String.class));
                instance.setTable(table);
                instance.setId((String)p.getSecond());
                instanceList.add(instance);
            });
            return instanceList;
        }
        Map<? extends Serializable, String> masterMap = this.selectMasterMap(tableHierarchy, pairList.stream().map(p -> (String)p.getSecond()).distinct().collect(Collectors.toList()));
        masterMap.forEach((k, v) -> pairList.stream().filter(p -> ((String)p.getSecond()).equals(ConvertUtils.convert(k, String.class))).findAny().get().setSecond(v));
        return this.selectAncientList(tableHierarchy.getMasterTableName(), pairList);
    }
}

