/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.log.service.impl;

import com.blueconic.browscap.Capabilities;
import java.time.LocalDateTime;
import java.util.List;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.security.AccountCategory;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.ServletUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.log.bean.CoreLoginLogBean;
import net.sinodawn.module.sys.log.dao.CoreLoginLogDao;
import net.sinodawn.module.sys.log.service.CoreLoginLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CoreLoginLogServiceImpl
implements CoreLoginLogService {
    @Autowired
    private CoreLoginLogDao loginLogDao;

    @Override
    public CoreLoginLogDao getDao() {
        return this.loginLogDao;
    }

    @Override
    public void insertLoginSuccessLog(String token, String userId, String orgId) {
        CoreLoginLogBean loginLog = new CoreLoginLogBean();
        loginLog.setId(ApplicationContextHelper.getNextIdentity());
        loginLog.setToken(token);
        loginLog.setUserId(userId);
        loginLog.setStatus("1");
        loginLog.setOrgId(orgId);
        loginLog.setLoginIp(ServletUtils.getRemoteIp(ServletUtils.getCurrentRequest()));
        loginLog.setLoginTime(LocalDateTime.now());
        this.setClientCapabilities(loginLog);
        this.getDao().insert(loginLog);
    }

    @Override
    public void insertLoginFailureLog(String userId, String remark) {
        CoreLoginLogBean loginLog = new CoreLoginLogBean();
        loginLog.setId(ApplicationContextHelper.getNextIdentity());
        loginLog.setUserId(userId);
        loginLog.setStatus("0");
        loginLog.setRemark(remark);
        loginLog.setLoginIp(ServletUtils.getRemoteIp(ServletUtils.getCurrentRequest()));
        loginLog.setLoginTime(LocalDateTime.now());
        this.setClientCapabilities(loginLog);
        this.getDao().insert(loginLog);
    }

    @Override
    public List<CoreLoginLogBean> selectOnlineUserLoginLogList(@Nullable String userId) {
        CoreLoginLogBean logSearchTerms = BeanUtils.getPropertyListenerProxy(CoreLoginLogBean.class);
        logSearchTerms.setLogoutTime(null);
        logSearchTerms.setStatus("1");
        if (!StringUtils.isBlank(userId)) {
            logSearchTerms.setUserId(userId);
        }
        return this.getDao().selectList(logSearchTerms, new Order[0]);
    }

    @Override
    public CoreLoginLogBean getCurrentLoginLog(String userId) {
        CoreLoginLogBean logSearchTerms = BeanUtils.getPropertyListenerProxy(CoreLoginLogBean.class);
        logSearchTerms.setToken(AuthenticationHelper.getLoginUserToken());
        logSearchTerms.setUserId(userId);
        logSearchTerms.setLogoutTime(null);
        logSearchTerms.setStatus("1");
        return this.getDao().selectOneIfPresent(logSearchTerms, new String[0]);
    }

    @Override
    public Page<CoreLoginLogBean> selectOnlinePagination(RestJsonWrapperBean wrapper) {
        return this.selectPaginationByFilter(SearchFilter.instance().match("LOGOUTTIME", null).filter(MatchPattern.EQ).match("STATUS", "1").filter(MatchPattern.EQ), wrapper);
    }

    @Override
    public void offline(RestJsonWrapperBean wrapper) {
        List<Long> loginLogIdList = wrapper.parseId(Long.class);
        List<CoreLoginLogBean> loginLogList = this.getDao().selectListByIds(loginLogIdList, new Order[0]);
        if (!loginLogList.isEmpty()) {
            String remark = "\u5f3a\u5236\u4e0b\u7ebf\uff08\u64cd\u4f5c\u4eba\uff1a" + LocalContextHelper.getLoginUserId() + "\uff09";
            loginLogList.forEach(l -> AuthenticationHelper.markOffline(l.getToken(), AccountCategory.OFFLINE.name()));
            loginLogList.forEach(l -> AuthenticationHelper.logout(l.getToken(), remark));
        }
    }

    @Override
    @Transactional
    public void assignLogout(String token, String remark) {
        if (!StringUtils.isBlank(token)) {
            CoreLoginLogBean filter = new CoreLoginLogBean();
            filter.setToken(token);
            CoreLoginLogBean loginLog = BeanUtils.getPropertyListenerProxy(this.getDao().selectOne(filter, new String[0]));
            loginLog.setLogoutTime(LocalDateTime.now());
            loginLog.setRemark(remark);
            this.getDao().update(loginLog, new String[0]);
        }
    }

    private void setClientCapabilities(CoreLoginLogBean loginLog) {
        Capabilities capabilities = ServletUtils.getCurrentRequestCapabilities();
        if (capabilities != null) {
            loginLog.setDevice(capabilities.getDeviceType());
            StringBuilder browser = new StringBuilder();
            if (!StringUtils.isEmpty(capabilities.getBrowser())) {
                browser.append(capabilities.getBrowser());
            }
            if (!StringUtils.isEmpty(capabilities.getBrowserMajorVersion())) {
                if (browser.length() > 0) {
                    browser.append(" ");
                }
                browser.append(capabilities.getBrowserMajorVersion());
            }
            if (!StringUtils.isEmpty(capabilities.getBrowserType())) {
                if (browser.length() > 0) {
                    browser.append(" ");
                }
                browser.append(capabilities.getBrowserType());
            }
            loginLog.setBrowser(browser.toString());
            StringBuilder platform = new StringBuilder(capabilities.getPlatform());
            if (!StringUtils.isEmpty(capabilities.getPlatformVersion())) {
                platform.append(" ").append(capabilities.getPlatformVersion());
            }
            loginLog.setPlatform(platform.toString());
        }
    }
}

