/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.validator;

import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.data.DataValidator;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreBpmnProcDeletableValidator
implements DataValidator {
    @Autowired
    private CoreBpmnProcService procService;
    @Autowired
    private CoreBpmnInstanceService instanceService;

    @Override
    public boolean doValid(Object ... args) {
        List<CoreBpmnProcBean> deleteProcList = ((RestJsonWrapperBean)args[0]).parse(CoreBpmnProcBean.class);
        List procIdList = deleteProcList.stream().map(CoreBpmnProcBean::getId).collect(Collectors.toList());
        List instanceList = this.instanceService.getDao().selectListByOneColumnValues(procIdList, "PROCID", new Order[0]);
        if (!instanceList.isEmpty()) {
            List usedProcIdList = instanceList.stream().map(CoreBpmnInstanceBean::getProcId).collect(Collectors.toList());
            List usedProcList = this.procService.selectListByIds(usedProcIdList);
            StringBuilder sb = new StringBuilder();
            for (CoreBpmnProcBean usedProc : usedProcList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(usedProc.getProcCode());
            }
            this.addConstraintViolation(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_PROC.TIP.UNABLE_DELETE_INUSE_PROC", sb.toString()));
            return false;
        }
        return true;
    }
}

