/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.validator;

import java.util.List;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.framework.validator.data.DataValidator;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftOrgBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreBpmnDraftSubmittableValidator
implements DataValidator {
    @Autowired
    private CoreBpmnProcService procService;
    @Autowired
    private CoreBpmnProcOrgService procOrgService;
    @Autowired
    private CoreBpmnDraftService draftService;
    @Autowired
    private CoreBpmnDraftOrgService draftOrgService;
    @Autowired
    private CoreBpmnDiagramService diagramService;

    @Override
    public boolean doValid(Object ... args) {
        List<Object> userTaskList;
        Long id = (Long)args[0];
        CoreBpmnDraftBean draft = (CoreBpmnDraftBean)this.draftService.selectById(id);
        Long diagramId = draft.getDiagramId();
        String diagram = this.diagramService.selectColumnById(diagramId, "DIAGRAM", String.class);
        if (StringUtils.isBlank(diagram)) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.CANNOT_EMPTY");
            return false;
        }
        Document document = XmlUtils.read(CoreBpmnHelper.getCorrectedDiagram(diagram));
        boolean flag = true;
        List<Element> startEventList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.START_EVENT);
        if (startEventList.isEmpty()) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.NO_START_EVENT");
            flag = false;
        } else if (startEventList.size() > 1) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MULTIPLE_START_EVENT");
            flag = false;
        }
        List<Element> endEventList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.END_EVENT);
        if (endEventList.isEmpty()) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.NO_END_EVENT");
            flag = false;
        } else if (endEventList.size() > 1) {
            this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MULTIPLE_END_EVENT");
            flag = false;
        }
        if (flag && !(userTaskList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.USER_TASK)).isEmpty()) {
            for (Element element : userTaskList) {
                String[] dynamicValues;
                String statusCode = XmlUtils.getAttributeValue(element, "statusCode");
                if (StringUtils.isEmpty(statusCode)) {
                    this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.STATUS_CODE_NOT_ASSIGNED");
                    return false;
                }
                Element element2 = startEventList.get(0);
                Element endEvent = endEventList.get(0);
                if (statusCode.equals(XmlUtils.getAttributeValue(element2, "statusCode")) || statusCode.equals(XmlUtils.getAttributeValue(endEvent, "statusCode")) || userTaskList.stream().filter(u -> statusCode.equals(XmlUtils.getAttributeValue((Element)u, "statusCode"))).count() > 1L) {
                    this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.STATUS_CODE_NOT_UNIQUE");
                    return false;
                }
                String dynamic = XmlUtils.getAttributeValue(element, "dynamic");
                if (StringUtils.isEmpty(dynamic)) continue;
                String[] var16 = dynamicValues = StringUtils.split(dynamic, ",");
                int var17 = dynamicValues.length;
                for (int var18 = 0; var18 < var17; ++var18) {
                    String value = var16[var18];
                    if (StringUtils.startsWith(value, "u:") || StringUtils.startsWith(value, "r:")) continue;
                    this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.DYNAMIC_INVALID");
                    return false;
                }
            }
        }
        if (flag) {
            CoreBpmnProcBean filter = new CoreBpmnProcBean();
            filter.setProcCode(draft.getProcCode());
            CoreBpmnProcBean coreBpmnProcBean = this.procService.getDao().selectFirstIfPresent((CoreBpmnProcBean)filter, Order.desc("ID"));
            if (coreBpmnProcBean != null && coreBpmnProcBean.getProcVersion() + 1L != draft.getProcVersion()) {
                this.addConstraintViolation("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.INVALID_VERSION");
                return false;
            }
        }
        if (flag && !(userTaskList = this.procService.selectBpmnProcListByServiceId(draft.getServiceId())).isEmpty()) {
            CoreBpmnDraftOrgBean draftOrgFilter = new CoreBpmnDraftOrgBean();
            draftOrgFilter.setDraftId(draft.getId());
            List<CoreBpmnDraftOrgBean> list = this.draftOrgService.selectList(draftOrgFilter, new Order[0]);
            for (CoreBpmnProcBean coreBpmnProcBean : userTaskList) {
                if (coreBpmnProcBean.getProcCode().equals(draft.getProcCode()) || !ObjectUtils.equals(StringUtils.trim(coreBpmnProcBean.getExpression()), StringUtils.trim(draft.getExpression()))) continue;
                CoreBpmnProcOrgBean procOrgFilter = new CoreBpmnProcOrgBean();
                procOrgFilter.setProcId(coreBpmnProcBean.getId());
                List<CoreBpmnProcOrgBean> procOrgList = this.procOrgService.selectList(procOrgFilter, new Order[0]);
                if (!(procOrgList.isEmpty() ? list.isEmpty() : !list.isEmpty() && procOrgList.stream().anyMatch(o -> draftOrgList.stream().anyMatch(d -> d.getUsedOrgId().equals(o.getUsedOrgId()))))) continue;
                return false;
            }
        }
        return flag;
    }
}

