/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.cache.redis.annotation.SinoCacheEvict;
import net.sinodawn.framework.cache.redis.annotation.SinoCacheable;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.io.file.FilePathManager;
import net.sinodawn.framework.io.file.FileScope;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.module.item.file.manager.CoreFileManager;
import net.sinodawn.module.item.file.utils.CoreFileUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnImportDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnProcDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreBpmnProcServiceImpl
implements CoreBpmnProcService {
    @Autowired
    private CoreBpmnProcDao procDao;
    @Autowired
    private CoreBpmnDiagramService diagramService;
    @Lazy
    @Autowired
    private CoreBpmnProcOrgService procOrgService;
    @Lazy
    @Autowired
    private CoreBpmnProcService proxyInstance;
    @Autowired
    @Lazy
    private CoreFileManager fileManager;

    @Override
    public CoreBpmnProcDao getDao() {
        return this.procDao;
    }

    @Override
    @SinoCacheable(value={"T_CORE_BPMN_PROC.PROCCODE"})
    public CoreBpmnProcBean selectLatestProc(String procCode) {
        CoreBpmnProcBean filter = new CoreBpmnProcBean();
        filter.setProcCode(procCode);
        return this.getDao().selectFirst(filter, Order.desc("PROCVERSION"));
    }

    @Override
    @SinoCacheEvict(value={"T_CORE_BPMN_PROC.PROCCODE"})
    public void cacheEvictLatestProc(String procCode) {
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DELETE)
    @Audit(value="AUDIT.DELETE")
    public void delete(RestJsonWrapperBean wrapper) {
        List<Long> procIdList = wrapper.parseId(Long.class);
        List<CoreBpmnProcBean> procList = this.getDao().selectListByIds(procIdList, new Order[0]);
        CoreBpmnProcService.super.delete(wrapper);
        this.diagramService.getDao().deleteByIdList(procList.stream().map(CoreBpmnProcBean::getDiagramId).collect(Collectors.toList()));
        procList.forEach(p -> this.proxyInstance.cacheEvictLatestProc(p.getProcCode()));
    }

    @Override
    public String getBpmnInputTextUrl(Long id) {
        CoreBpmnProcBean proc = (CoreBpmnProcBean)this.getDao().selectById(id);
        CoreBpmnDiagramBean diagram = (CoreBpmnDiagramBean)this.diagramService.selectById(proc.getDiagramId());
        CoreBpmnImportDTO bpmnImport = new CoreBpmnImportDTO();
        bpmnImport.setServiceId(proc.getServiceId());
        bpmnImport.setProcCode(proc.getProcCode());
        bpmnImport.setExpression(proc.getExpression());
        bpmnImport.setExt$(proc.getExt$());
        bpmnImport.setDiagram(diagram.getDiagram());
        bpmnImport.setSvg(diagram.getSvg());
        CoreBpmnProcOrgBean procOrgFilter = new CoreBpmnProcOrgBean();
        procOrgFilter.setProcId(id);
        List<CoreBpmnProcOrgBean> procOrgList = this.procOrgService.selectList(procOrgFilter, Order.asc("ID"));
        bpmnImport.setUsedOrgIdList(procOrgList.stream().map(o -> o.getUsedOrgId()).collect(Collectors.toList()));
        FilePathDTO filePath = CoreFileUtils.toFilePath(FileScope.temp, "bpmn.json");
        FileUtils.write(FilePathManager.getLocalPath(filePath), JSON.toJSONString((Object)bpmnImport));
        this.fileManager.upload(filePath, FilePathManager.getLocalPath(filePath));
        return this.fileManager.getDownloadUrl(filePath);
    }

    @Override
    public Page<CoreBpmnProcOrgBean> selectProcOrgPagination(Long id, RestJsonWrapperBean wrapper) {
        return this.procOrgService.selectPaginationByFilter(SearchFilter.instance().match("PROCID", id).filter(MatchPattern.EQ), wrapper);
    }

    @Override
    public List<CoreBpmnProcBean> selectRuntimeBpmnProcList(String tableName, String usedOrgId) {
        return this.getDao().selectRuntimeBpmnProcList(tableName, usedOrgId);
    }

    @Override
    public List<CoreBpmnProcBean> selectBpmnProcListByServiceId(String serviceId) {
        return this.getDao().selectBpmnProcListByServiceId(serviceId);
    }
}

