/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.service.impl;

import java.util.List;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskRoleBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnInstanceTaskDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskRoleService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreBpmnInstanceTaskServiceImpl
implements CoreBpmnInstanceTaskService {
    @Autowired
    private CoreBpmnInstanceTaskDao instanceTaskDao;
    @Autowired
    private CoreBpmnInstanceTaskUserService instanceTaskUserService;
    @Autowired
    private CoreBpmnInstanceTaskRoleService instanceTaskRoleService;

    @Override
    public CoreBpmnInstanceTaskDao getDao() {
        return this.instanceTaskDao;
    }

    @Override
    public List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(@Nullable String userId, List<Long> instIdList) {
        return this.getDao().selectAuditableInstanceTaskList(userId, instIdList);
    }

    @Override
    @Async
    @Transactional
    public void cleanCandidatorAsync(Long id) {
        CoreBpmnInstanceTaskUserBean taskUserFilter = new CoreBpmnInstanceTaskUserBean();
        taskUserFilter.setInstTaskId(id);
        this.instanceTaskUserService.getDao().deleteBy((CoreBpmnInstanceTaskUserBean)taskUserFilter, "INSTTASKID");
        CoreBpmnInstanceTaskRoleBean taskRoleFilter = new CoreBpmnInstanceTaskRoleBean();
        taskRoleFilter.setInstTaskId(id);
        this.instanceTaskRoleService.getDao().deleteBy((CoreBpmnInstanceTaskRoleBean)taskRoleFilter, "INSTTASKID");
    }

    @Override
    public Page<CoreBpmnInstanceTaskUserBean> selectInstTaskUserList(Long id, RestJsonWrapperBean wrapper) {
        return this.instanceTaskUserService.selectPaginationByFilter(SearchFilter.instance().match("INSTTASKID", id).filter(MatchPattern.EQ), wrapper);
    }

    @Override
    public Page<CoreBpmnInstanceTaskRoleBean> selectInstTaskRoleList(Long id, RestJsonWrapperBean wrapper) {
        return this.instanceTaskRoleService.selectPaginationByFilter(SearchFilter.instance().match("INSTTASKID", id).filter(MatchPattern.EQ), wrapper);
    }

    @Override
    @Transactional
    public void insertInstTaskUser(Long id, RestJsonWrapperBean wrapper) {
        List<CoreBpmnInstanceTaskUserBean> instanceTaskUserList = wrapper.parse(CoreBpmnInstanceTaskUserBean.class);
        CoreBpmnInstanceTaskBean instanceTask = (CoreBpmnInstanceTaskBean)this.getDao().selectById(id);
        instanceTaskUserList.forEach(t -> {
            t.setId(ApplicationContextHelper.getNextIdentity());
            t.setInstId(instanceTask.getInstId());
            t.setInstTaskId(id);
        });
        this.instanceTaskUserService.getDao().insert(instanceTaskUserList);
    }

    @Override
    @Transactional
    public void insertInstTaskRole(Long id, RestJsonWrapperBean wrapper) {
        List<CoreBpmnInstanceTaskRoleBean> instanceTaskRoleList = wrapper.parse(CoreBpmnInstanceTaskRoleBean.class);
        CoreBpmnInstanceTaskBean instanceTask = (CoreBpmnInstanceTaskBean)this.getDao().selectById(id);
        instanceTaskRoleList.forEach(t -> {
            t.setId(ApplicationContextHelper.getNextIdentity());
            t.setInstId(instanceTask.getInstId());
            t.setInstTaskId(id);
        });
        this.instanceTaskRoleService.getDao().insert(instanceTaskRoleList);
    }

    @Override
    @Transactional
    public void deleteInstTaskUser(Long id, RestJsonWrapperBean wrapper) {
        List<CoreBpmnInstanceTaskUserBean> instanceTaskUserList = wrapper.parse(CoreBpmnInstanceTaskUserBean.class);
        this.instanceTaskUserService.getDao().deleteBy(instanceTaskUserList, new String[0]);
    }

    @Override
    @Transactional
    public void deleteInstTaskRole(Long id, RestJsonWrapperBean wrapper) {
        List<CoreBpmnInstanceTaskRoleBean> instanceTaskRoleList = wrapper.parse(CoreBpmnInstanceTaskRoleBean.class);
        this.instanceTaskRoleService.getDao().deleteBy(instanceTaskRoleList, new String[0]);
    }
}

