/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnCommentBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnRejectableTaskDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnRuntimeDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnTargetBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.TaskStatus;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnCommentService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnExtService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnInstanceTaskService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnTargetService;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CoreBpmnExtServiceImpl
implements CoreBpmnExtService {
    @Autowired
    private CoreBpmnInstanceService instanceService;
    @Autowired
    private CoreBpmnProcService procService;
    @Autowired
    private CoreBpmnCommentService commentService;
    @Autowired
    private CoreBpmnDiagramService diagramService;
    @Autowired
    private CoreBpmnInstanceTaskService instanceTaskService;
    @Autowired
    private CoreBpmnTargetService targetService;

    @Override
    public <T extends Persistable<ID>, ID extends Serializable> CoreBpmnRuntimeDTO selectBpmnRuntimeInfo(String table, String id) {
        CoreBpmnRuntimeDTO runtime = new CoreBpmnRuntimeDTO();
        CoreBpmnInstanceBean filter = new CoreBpmnInstanceBean();
        filter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
        CoreBpmnInstanceBean instance = this.instanceService.getDao().selectOneIfPresent((CoreBpmnInstanceBean)filter, new String[0]);
        if (instance != null) {
            runtime.setInstanceId(instance.getId());
            runtime.setProcId(instance.getProcId());
            runtime.setDiagramId(instance.getDiagramId());
        } else {
            CoreBpmnCommentBean comment;
            Class<?> idType;
            Serializable actualId;
            Object service = ApplicationContextHelper.getServiceByTable(table);
            String processStatus = null;
            Long procId = null;
            if (service != null && StringUtils.startsWithIgnoreCase(processStatus = service.selectColumnById((Serializable)(actualId = (Serializable)ConvertUtils.convert(id, idType = service.getDao().getEntityContext().getIdContext().getType())), "PROCESSSTATUS"), ProcessStatus.DRAFT.name())) {
                procId = service.selectProcId((Serializable)actualId);
            }
            if (procId == null && (comment = (CoreBpmnCommentBean)this.commentService.selectFirstByFilter(SearchFilter.instance().match("TARGETID", CoreBpmnHelper.getTargetId(table, id)).filter(MatchPattern.EQ).match("PROCID", null).filter(MatchPattern.DIFFER), Order.desc("ID"))) != null) {
                procId = comment.getProcId();
            }
            runtime.setProcessStatus(processStatus);
            if (procId != null) {
                CoreBpmnProcBean proc = (CoreBpmnProcBean)this.procService.selectById(procId);
                runtime.setProcId(proc.getId());
                runtime.setDiagramId(proc.getDiagramId());
            }
        }
        return runtime;
    }

    @Override
    public List<CoreBpmnRejectableTaskDTO> selectBpmnRuntimeRejectableTaskList(RestJsonWrapperBean wrapper) {
        List<String> idList = wrapper.parseId(String.class);
        String table = Objects.requireNonNull(wrapper.getParamValue("bpmn_table"));
        String currentStatusCode = wrapper.getParamValue("bpmn_currentStatusCode");
        ArrayList<CoreBpmnRejectableTaskDTO> returnRejectableTaskList = new ArrayList<CoreBpmnRejectableTaskDTO>();
        ArrayList<CoreBpmnCommentBean> commentFilterList = new ArrayList<CoreBpmnCommentBean>();
        for (String id : idList) {
            CoreBpmnCommentBean commentFilter = new CoreBpmnCommentBean();
            commentFilter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
            commentFilterList.add(commentFilter);
        }
        List selectedCommentList = this.commentService.getDao().selectList(commentFilterList, Arrays.asList("TARGETID"), CollectionUtils.emptyList(), new Order[]{Order.desc("ID")});
        if (!selectedCommentList.isEmpty()) {
            CoreBpmnCommentBean lastComment = (CoreBpmnCommentBean)selectedCommentList.get(0);
            while (CommentStatus.CS_APPROVE.name().equalsIgnoreCase(lastComment.getStatus())) {
                selectedCommentList.remove(0);
                if (selectedCommentList.isEmpty()) break;
                lastComment = (CoreBpmnCommentBean)selectedCommentList.get(0);
            }
        }
        ArrayList<CoreBpmnInstanceBean> instanceFilterList = new ArrayList<CoreBpmnInstanceBean>();
        for (String id : idList) {
            CoreBpmnInstanceBean instanceFilter = new CoreBpmnInstanceBean();
            instanceFilter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
            instanceFilterList.add(instanceFilter);
        }
        List selectedInstanceList = this.instanceService.getDao().selectList(instanceFilterList, Arrays.asList("TARGETID"), CollectionUtils.emptyList(), new Order[0]);
        List<Long> instIdList = selectedInstanceList.stream().map(i -> i.getId()).collect(Collectors.toList());
        List<CoreBpmnInstanceTaskBean> selectedInstanceTaskList = this.instanceTaskService.selectAuditableInstanceTaskList(LocalContextHelper.getLoginUserId(), instIdList);
        for (String id : idList) {
            CoreBpmnInstanceBean instance = selectedInstanceList.stream().filter(i -> i.getTargetId().contentEquals(CoreBpmnHelper.getTargetId(table, id))).findFirst().get();
            List taskList = selectedInstanceTaskList.stream().filter(t -> instance.getId().equals(t.getInstId())).collect(Collectors.toList());
            if (taskList.isEmpty()) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.NOT_AUTHORIZED");
            }
            if (taskList.size() > 1 && !StringUtils.isEmpty(currentStatusCode)) {
                taskList.removeIf(t -> !t.getStatusCode().equals(currentStatusCode));
            }
            Document document = this.diagramService.getDocument(instance.getDiagramId());
            HashSet<String> previousStatusCodeList = new HashSet<String>();
            for (CoreBpmnInstanceTaskBean task : taskList) {
                previousStatusCodeList.addAll(BpmnDiagramHelper.getPreviousStatusCodeList(document, BpmnDiagramHelper.getProcessElementByStatusCode(document, task.getStatusCode())));
            }
            if (previousStatusCodeList.isEmpty()) {
                CoreBpmnRejectableTaskDTO startEvent = new CoreBpmnRejectableTaskDTO();
                startEvent.setStatusCode(CommentStatus.SUBMIT.name());
                startEvent.setTaskName(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.START_NODE", new String[0]));
                return Arrays.asList(startEvent);
            }
            ArrayList<CoreBpmnRejectableTaskDTO> rejectableTaskList = new ArrayList<CoreBpmnRejectableTaskDTO>();
            for (CoreBpmnCommentBean comment : selectedCommentList) {
                if (!comment.getTargetId().equals(CoreBpmnHelper.getTargetId(table, id))) continue;
                if (previousStatusCodeList.contains(comment.getStatusCode())) {
                    CoreBpmnRejectableTaskDTO rejectableTask = new CoreBpmnRejectableTaskDTO();
                    rejectableTask.setStatusCode(comment.getStatusCode());
                    rejectableTask.setTaskName(comment.getTaskName());
                    if (StringUtils.startsWithIgnoreCase(rejectableTask.getStatusCode(), ProcessStatus.DRAFT.name()) && StringUtils.isEmpty(rejectableTask.getTaskName())) {
                        rejectableTask.setTaskName(I18nHelper.getMessage("SINO.BPMN.COMMENT.START_NODE", new String[0]));
                    }
                    if (!rejectableTaskList.contains(rejectableTask)) {
                        rejectableTaskList.add(rejectableTask);
                    }
                }
                if (!CommentStatus.SUBMIT.name().equalsIgnoreCase(comment.getStatus())) continue;
                break;
            }
            if (returnRejectableTaskList.isEmpty()) {
                returnRejectableTaskList.addAll(rejectableTaskList);
                continue;
            }
            returnRejectableTaskList.removeIf(r -> !rejectableTaskList.contains(r));
        }
        return returnRejectableTaskList;
    }

    @Override
    public String selectBpmnDiagramSvg(Long id, Long instanceId) {
        CoreBpmnDiagramBean diagram = (CoreBpmnDiagramBean)this.diagramService.selectById(id);
        String svg = diagram.getSvg();
        if (instanceId != null) {
            CoreBpmnInstanceBean instance = (CoreBpmnInstanceBean)this.instanceService.selectById(instanceId);
            CoreBpmnCommentBean commentFilter = new CoreBpmnCommentBean();
            commentFilter.setTargetId(instance.getTargetId());
            List<CoreBpmnCommentBean> commentList = this.commentService.selectList(commentFilter, Order.desc("ID"));
            HashMap<String, CommentStatus> map = new HashMap<String, CommentStatus>();
            for (CoreBpmnCommentBean comment : commentList) {
                if (!map.containsKey(comment.getTaskId())) {
                    map.put(comment.getTaskId(), CommentStatus.valueOf(comment.getStatus()));
                }
                if (!CommentStatus.SUBMIT.name().equals(comment.getStatus())) continue;
                break;
            }
            CoreBpmnInstanceTaskBean taskFilter = new CoreBpmnInstanceTaskBean();
            taskFilter.setInstId(instanceId);
            taskFilter.setStatus(TaskStatus.CREATED.name());
            List<CoreBpmnInstanceTaskBean> taskList = this.instanceTaskService.selectList(taskFilter, new Order[0]);
            for (CoreBpmnInstanceTaskBean task : taskList) {
                map.put(task.getTaskId(), null);
            }
            svg = this.fillColor(svg, map);
        }
        return svg;
    }

    private String fillColor(String svg, Map<String, CommentStatus> map) {
        int dataElementIdPos = 0;
        while ((dataElementIdPos = svg.indexOf("data-element-id=\"", dataElementIdPos + 1)) > 0) {
            int dataElementIdEndPos;
            int dataElementIdStartPos = svg.indexOf("\"", dataElementIdPos + 1);
            String dataElementId = svg.substring(dataElementIdStartPos + 1, dataElementIdEndPos = svg.indexOf("\"", dataElementIdStartPos + 1));
            if (StringUtils.startsWithIgnoreCase(dataElementId, "SequenceFlow")) continue;
            svg = this.updateBackgroundColor(svg, dataElementId, map.get(dataElementId), map.containsKey(dataElementId));
            svg = this.updateStrokeColor(svg, dataElementId, map.get(dataElementId), map.containsKey(dataElementId));
            svg = this.updateTextColor(svg, dataElementId, map.get(dataElementId), map.containsKey(dataElementId));
        }
        return svg;
    }

    private String updateBackgroundColor(String svg, String dataElementId, CommentStatus status, boolean todo) {
        int elementPos = ((String)svg).indexOf("data-element-id=\"" + dataElementId + "\"");
        if (elementPos <= 0) {
            return svg;
        }
        int fillPos = ((String)svg).indexOf("fill:", elementPos);
        if (fillPos <= 0) {
            return svg;
        }
        int semicolonPos = ((String)svg).indexOf(";", fillPos);
        if (semicolonPos <= 0) {
            return svg;
        }
        if (!CommentStatus.SUBMIT.equals((Object)status)) {
            if (!CommentStatus.APPROVE.equals((Object)status) && !CommentStatus.CS_END.equals((Object)status)) {
                if (CommentStatus.REJECT.equals((Object)status)) {
                    svg = ((String)svg).substring(0, fillPos) + "fill:#ffecec" + ((String)svg).substring(semicolonPos);
                } else if (status == null) {
                    svg = todo ? ((String)svg).substring(0, fillPos) + "fill:#e7f4ff" + ((String)svg).substring(semicolonPos) : ((String)svg).substring(0, fillPos) + "fill:#f4f4f5" + ((String)svg).substring(semicolonPos);
                }
            } else {
                svg = ((String)svg).substring(0, fillPos) + "fill:#e7faef" + ((String)svg).substring(semicolonPos);
            }
        }
        return svg;
    }

    private String updateStrokeColor(String svg, String dataElementId, CommentStatus status, boolean todo) {
        int elementPos = ((String)svg).indexOf("data-element-id=\"" + dataElementId + "\"");
        if (elementPos <= 0) {
            return svg;
        }
        int strokePos = ((String)svg).indexOf("stroke:", elementPos);
        if (strokePos <= 0) {
            return svg;
        }
        int semicolonPos = ((String)svg).indexOf(";", strokePos);
        if (semicolonPos <= 0) {
            return svg;
        }
        if (CommentStatus.SUBMIT.equals((Object)status)) {
            svg = ((String)svg).substring(0, strokePos) + "stroke:#a1ebc2" + ((String)svg).substring(semicolonPos);
        } else if (!CommentStatus.APPROVE.equals((Object)status) && !CommentStatus.CS_END.equals((Object)status)) {
            if (CommentStatus.REJECT.equals((Object)status)) {
                svg = ((String)svg).substring(0, strokePos) + "stroke:#ffb6b6" + ((String)svg).substring(semicolonPos);
            } else if (status == null) {
                svg = todo ? ((String)svg).substring(0, strokePos) + "stroke:#a3d3ff" + ((String)svg).substring(semicolonPos) : ((String)svg).substring(0, strokePos) + "stroke:#d3d4d6" + ((String)svg).substring(semicolonPos);
            }
        } else {
            svg = ((String)svg).substring(0, strokePos) + "stroke:#a1ebc2" + ((String)svg).substring(semicolonPos);
        }
        return svg;
    }

    private String updateTextColor(String svg, String dataElementId, CommentStatus status, boolean todo) {
        int elementPos = ((String)svg).indexOf("data-element-id=\"" + dataElementId + "\"");
        if (elementPos <= 0) {
            return svg;
        }
        int textPos = ((String)svg).indexOf("<text ", elementPos);
        if (textPos <= 0) {
            return svg;
        }
        int fillPos = ((String)svg).indexOf("fill:", textPos);
        if (fillPos <= 0) {
            return svg;
        }
        int semicolonPos = ((String)svg).indexOf(";", fillPos);
        if (!CommentStatus.SUBMIT.equals((Object)status)) {
            if (!CommentStatus.APPROVE.equals((Object)status) && !CommentStatus.CS_END.equals((Object)status)) {
                if (CommentStatus.REJECT.equals((Object)status)) {
                    svg = ((String)svg).substring(0, fillPos) + "fill:#ff4949" + ((String)svg).substring(semicolonPos);
                } else if (status == null) {
                    svg = todo ? ((String)svg).substring(0, fillPos) + "fill:#1890ff" + ((String)svg).substring(semicolonPos) : ((String)svg).substring(0, fillPos) + "fill:#000; fill-opacity: 0.65" + ((String)svg).substring(semicolonPos);
                }
            } else {
                svg = ((String)svg).substring(0, fillPos) + "fill:#13ce66" + ((String)svg).substring(semicolonPos);
            }
        }
        return svg;
    }

    @Override
    public Page<CoreBpmnTargetBean> selectBpmnRuntimeTargetList(RestJsonWrapperBean wrapper) {
        return this.targetService.selectPaginationByFilter(SearchFilter.instance().match("PROCESSSTATUS", "APPROVE").filter(MatchPattern.SB), wrapper);
    }
}

