/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.context.instance.EntityHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MapperParameter;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDraftOrgBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnImportDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcOrgBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnDraftDao;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDraftService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcOrgService;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnProcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CoreBpmnDraftServiceImpl
implements CoreBpmnDraftService {
    @Autowired
    private CoreBpmnDraftDao draftDao;
    @Autowired
    private CoreBpmnDraftOrgService draftOrgService;
    @Autowired
    private CoreBpmnDiagramService diagramService;
    @Autowired
    @Lazy
    private CoreBpmnProcService procService;
    @Autowired
    @Lazy
    private CoreBpmnProcOrgService procOrgService;

    @Override
    public CoreBpmnDraftDao getDao() {
        return this.draftDao;
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long insert(RestJsonWrapperBean wrapper) {
        CoreBpmnDiagramBean diagram = new CoreBpmnDiagramBean();
        diagram.setId(ApplicationContextHelper.getNextIdentity());
        this.diagramService.getDao().insert((CoreBpmnDiagramBean)diagram);
        CoreBpmnDraftBean draft = wrapper.parseUnique(CoreBpmnDraftBean.class);
        draft.setId(ApplicationContextHelper.getNextIdentity());
        draft.setDiagramId(diagram.getId());
        this.getDao().insert(draft);
        return draft.getId();
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public Long insertByProcId(Long procId) {
        CoreBpmnProcBean proc = (CoreBpmnProcBean)this.procService.selectById(procId);
        CoreBpmnDiagramBean procDiagram = (CoreBpmnDiagramBean)this.diagramService.selectById(proc.getDiagramId());
        CoreBpmnProcOrgBean procOrgFilter = new CoreBpmnProcOrgBean();
        procOrgFilter.setProcId(procId);
        List<CoreBpmnProcOrgBean> procOrgList = this.procOrgService.selectList(procOrgFilter, Order.asc("ID"));
        CoreBpmnDiagramBean diagram = new CoreBpmnDiagramBean();
        BeanUtils.copyProperties((Object)procDiagram, (Object)diagram, new String[0]);
        diagram.setId(ApplicationContextHelper.getNextIdentity());
        EntityHelper.assignCreatedElement(diagram);
        this.diagramService.getDao().insert((CoreBpmnDiagramBean)diagram);
        CoreBpmnDraftBean draft = new CoreBpmnDraftBean();
        BeanUtils.copyProperties((Object)proc, (Object)draft, new String[0]);
        draft.setId(ApplicationContextHelper.getNextIdentity());
        draft.setProcVersion(draft.getProcVersion() + 1L);
        draft.setDiagramId(diagram.getId());
        EntityHelper.assignCreatedElement(draft);
        this.getDao().insert(draft);
        if (!procOrgList.isEmpty()) {
            ArrayList<CoreBpmnDraftOrgBean> draftOrgList = new ArrayList<CoreBpmnDraftOrgBean>();
            for (CoreBpmnProcOrgBean procOrg : procOrgList) {
                CoreBpmnDraftOrgBean draftOrg = new CoreBpmnDraftOrgBean();
                draftOrg.setId(ApplicationContextHelper.getNextIdentity());
                draftOrg.setDraftId(draft.getId());
                draftOrg.setUsedOrgId(procOrg.getUsedOrgId());
                draftOrgList.add(draftOrg);
            }
            this.draftOrgService.getDao().insert(draftOrgList);
        }
        return draft.getId();
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public void submit(Long id) {
        CoreBpmnDraftBean draft = (CoreBpmnDraftBean)this.selectById(id);
        CoreBpmnDraftOrgBean draftOrgFiltre = new CoreBpmnDraftOrgBean();
        draftOrgFiltre.setDraftId(id);
        List<CoreBpmnDraftOrgBean> draftOrgList = this.draftOrgService.selectList(draftOrgFiltre, Order.asc("ID"));
        CoreBpmnProcBean proc = new CoreBpmnProcBean();
        BeanUtils.copyProperties((Object)draft, (Object)proc, new String[0]);
        proc.setId(ApplicationContextHelper.getNextIdentity());
        EntityHelper.assignCreatedElement(proc);
        this.procService.getDao().insert((CoreBpmnProcBean)proc);
        if (!draftOrgList.isEmpty()) {
            ArrayList<CoreBpmnProcOrgBean> procOrgList = new ArrayList<CoreBpmnProcOrgBean>();
            for (CoreBpmnDraftOrgBean draftOrg : draftOrgList) {
                CoreBpmnProcOrgBean procOrg = new CoreBpmnProcOrgBean();
                procOrg.setId(ApplicationContextHelper.getNextIdentity());
                procOrg.setProcId(proc.getId());
                procOrg.setUsedOrgId(draftOrg.getUsedOrgId());
                procOrgList.add(procOrg);
            }
            this.procOrgService.getDao().insert(procOrgList);
        }
        this.getDao().delete(draft.getId());
        this.draftOrgService.getDao().deleteBy(draftOrgList, new String[0]);
        this.procService.cacheEvictLatestProc(draft.getProcCode());
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DELETE)
    @Audit(value="AUDIT.DELETE")
    public void delete(RestJsonWrapperBean wrapper) {
        List<CoreBpmnDraftBean> deleteList = wrapper.parse(CoreBpmnDraftBean.class);
        if (!deleteList.isEmpty()) {
            List diagramIdList = deleteList.stream().map(d -> d.getDiagramId()).collect(Collectors.toList());
            diagramIdList.stream().filter(i -> i != null).forEach(i -> this.diagramService.delete(i));
            this.getDao().deleteBy(deleteList, new String[0]);
        }
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.IMPORT)
    @Audit(value="AUDIT.IMPORT")
    public void importBpmn(List<CoreBpmnImportDTO> bpmnImportList) {
        List procCodeList = bpmnImportList.stream().map(i -> i.getProcCode()).collect(Collectors.toList());
        List selectedDraftList = this.getDao().selectListByOneColumnValues(procCodeList, "PROCCODE", new Order[0]);
        this.getDao().deleteBy(selectedDraftList, new String[0]);
        List diagramIdList = selectedDraftList.stream().map(d -> d.getDiagramId()).collect(Collectors.toList());
        diagramIdList.stream().filter(i -> i != null).forEach(i -> this.diagramService.delete(i));
        ArrayList<CoreBpmnDiagramBean> insertDiagramList = new ArrayList<CoreBpmnDiagramBean>();
        ArrayList<CoreBpmnDraftBean> insertDraftList = new ArrayList<CoreBpmnDraftBean>();
        ArrayList<CoreBpmnDraftOrgBean> insertDraftOrgList = new ArrayList<CoreBpmnDraftOrgBean>();
        for (CoreBpmnImportDTO bpmnImport : bpmnImportList) {
            CoreBpmnDiagramBean diagram = new CoreBpmnDiagramBean();
            diagram.setId(ApplicationContextHelper.getNextIdentity());
            diagram.setDiagram(bpmnImport.getDiagram());
            diagram.setSvg(bpmnImport.getSvg());
            insertDiagramList.add(diagram);
            CoreBpmnDraftBean draft = new CoreBpmnDraftBean();
            draft.setId(ApplicationContextHelper.getNextIdentity());
            draft.setProcCode(bpmnImport.getProcCode());
            draft.setServiceId(bpmnImport.getServiceId());
            draft.setExpression(bpmnImport.getExpression());
            draft.setDiagramId(diagram.getId());
            if (bpmnImport.getUsedOrgIdList() != null) {
                for (String usedOrgId : bpmnImport.getUsedOrgIdList()) {
                    CoreBpmnDraftOrgBean draftOrg = new CoreBpmnDraftOrgBean();
                    draftOrg.setId(ApplicationContextHelper.getNextIdentity());
                    draftOrg.setDraftId(draft.getId());
                    draftOrg.setUsedOrgId(usedOrgId);
                    insertDraftOrgList.add(draftOrg);
                }
            }
            MapperParameter parameter = new MapperParameter();
            parameter.setFilter(SearchFilter.instance().match("PROCCODE", bpmnImport.getProcCode()).filter(MatchPattern.SEQ));
            parameter.put("service", "modifiable");
            List procList = this.procService.selectList(parameter);
            if (!procList.isEmpty()) {
                draft.setProcVersion(((CoreBpmnProcBean)procList.get(0)).getProcVersion() + 1L);
            }
            insertDraftList.add(draft);
        }
        this.diagramService.getDao().insert(insertDiagramList);
        this.getDao().insert(insertDraftList);
        this.draftOrgService.getDao().insert(insertDraftOrgList);
    }

    @Override
    public Page<CoreBpmnDraftOrgBean> selectDraftOrgPagination(Long id, RestJsonWrapperBean wrapper) {
        return this.draftOrgService.selectPaginationByFilter(SearchFilter.instance().match("DRAFTID", id).filter(MatchPattern.EQ), wrapper);
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.INSERT)
    @Audit(value="AUDIT.INSERT")
    public void insertDraftOrg(Long id, RestJsonWrapperBean wrapper) {
        List<CoreBpmnDraftOrgBean> draftOrgList = wrapper.parse(CoreBpmnDraftOrgBean.class);
        draftOrgList.forEach(o -> {
            o.setId(ApplicationContextHelper.getNextIdentity());
            o.setDraftId(id);
        });
        this.draftOrgService.getDao().insert(draftOrgList);
    }

    @Override
    @Transactional
    @AuditTrailEntry(value=AuditTrailType.DELETE)
    @Audit(value="AUDIT.DELETE")
    public void deleteDraftOrg(Long id, RestJsonWrapperBean wrapper) {
        this.draftOrgService.delete(wrapper);
    }
}

