/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.service.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sinodawn.framework.cache.redis.annotation.SinoCacheable;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ConvertUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramSequenceFlowConditionDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramTaskCandidatorDTO;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnDiagramDao;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.service.CoreBpmnDiagramService;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class CoreBpmnDiagramServiceImpl
implements CoreBpmnDiagramService {
    @Autowired
    private CoreBpmnDiagramDao diagramDao;
    @Autowired
    @Lazy
    private CoreBpmnDiagramService proxyInstance;

    @Override
    public CoreBpmnDiagramDao getDao() {
        return this.diagramDao;
    }

    @Override
    public String selectColumnById(Long id, String column) {
        CoreBpmnDiagramBean diagram = (CoreBpmnDiagramBean)this.proxyInstance.selectById(id);
        Method method = ReflectionUtils.findReadMethod(this.getDao().getType(), column);
        return method != null ? ConvertUtils.convert(ReflectionUtils.invokeMethod(method, diagram, new Object[0]), String.class) : diagram.getExt$Item(column);
    }

    @Override
    @SinoCacheable(value={"T_CORE_BPMN_DIAGRAM.DOCUMENT"})
    public Document getDocument(Long id) {
        return XmlUtils.read(CoreBpmnHelper.getCorrectedDiagram(this.selectColumnById(id, "DIAGRAM")));
    }

    @Override
    @SinoCacheable(value={"T_CORE_BPMN_DIAGRAM.TASKCANDIDATOR"})
    public List<CoreBpmnDiagramTaskCandidatorDTO> selectTaskCandidatorList(Long id) {
        ArrayList<CoreBpmnDiagramTaskCandidatorDTO> taskCandidatorList = new ArrayList<CoreBpmnDiagramTaskCandidatorDTO>();
        Document document = this.proxyInstance.getDocument(id);
        if (document == null) {
            return CollectionUtils.emptyList();
        }
        List<Element> userTaskList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.USER_TASK);
        for (Element userTask : userTaskList) {
            Map<Long, String> roleMap;
            CoreBpmnDiagramTaskCandidatorDTO taskCandidator = new CoreBpmnDiagramTaskCandidatorDTO();
            taskCandidator.setStatusCode(XmlUtils.getAttributeValue(userTask, "statusCode"));
            taskCandidator.setTaskName(XmlUtils.getAttributeValue(userTask, "name"));
            taskCandidator.setInitiator(StringUtils.isEmpty(BpmnDiagramHelper.getUserTaskInitiatorValue(userTask)) ? "0" : "1");
            taskCandidator.setDynamic(BpmnDiagramHelper.getUserTaskDynamicValue(userTask));
            Map<String, String> userMap = BpmnDiagramHelper.getUserTaskCandidatorValue(userTask);
            if (!userMap.isEmpty()) {
                taskCandidator.setUser(StringUtils.join(userMap.values(), ","));
            }
            if (!(roleMap = BpmnDiagramHelper.getUserTaskRoleValue(userTask)).isEmpty()) {
                taskCandidator.setRole(StringUtils.join(roleMap.values(), ","));
            }
            taskCandidatorList.add(taskCandidator);
        }
        return taskCandidatorList;
    }

    @Override
    @SinoCacheable(value={"T_CORE_BPMN_DIAGRAM.SEQUENCEFLOWCONDITION"})
    public List<CoreBpmnDiagramSequenceFlowConditionDTO> selectSequenceFlowConditionList(Long id) {
        ArrayList<CoreBpmnDiagramSequenceFlowConditionDTO> conditionList = new ArrayList<CoreBpmnDiagramSequenceFlowConditionDTO>();
        Document document = this.proxyInstance.getDocument(id);
        if (document == null) {
            return CollectionUtils.emptyList();
        }
        List<Element> sequenceFlowList = BpmnDiagramHelper.getProcessElementList(document, ProcessElementType.SEQUENCE_FLOW);
        for (Element sequenceFlow : sequenceFlowList) {
            String conditionExpression = BpmnDiagramHelper.getConditionExpression(sequenceFlow);
            if (StringUtils.isEmpty(conditionExpression)) continue;
            CoreBpmnDiagramSequenceFlowConditionDTO condition = new CoreBpmnDiagramSequenceFlowConditionDTO();
            condition.setConditionExpression(conditionExpression);
            Element sourceElement = BpmnDiagramHelper.getSourceElement(document, sequenceFlow);
            condition.setSourceTask(this.getElementDesc(sourceElement));
            Element targetElement = BpmnDiagramHelper.getTargetElement(document, sequenceFlow);
            condition.setTargetTask(this.getElementDesc(targetElement));
            conditionList.add(condition);
        }
        return conditionList;
    }

    private String getElementDesc(Element element) {
        String name = XmlUtils.getAttributeValue(element, "name");
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty(name)) {
            sb.append(name).append("(");
        }
        if (ProcessElementType.START_EVENT.getName().equals(element.getName())) {
            sb.append(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.START_NODE", new String[0]));
        } else if (ProcessElementType.EXCLUSIVE_GATEWAY.getName().equals(element.getName())) {
            sb.append(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.EXCLUSIVE_GATEWAY", new String[0]));
        } else if (ProcessElementType.PARALLEL_GATEWAY.getName().equals(element.getName())) {
            sb.append(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.PARALLEL_GATEWAY", new String[0]));
        } else if (ProcessElementType.END_EVENT.getName().equals(element.getName())) {
            sb.append(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.END_NODE", new String[0]));
        } else {
            if (!ProcessElementType.USER_TASK.getName().equals(element.getName())) {
                throw new UnsupportedException(element.asXML());
            }
            sb.append(I18nHelper.getMessage("CORE.MODULE.SYS.T_CORE_BPMN_DIAGRAM.USER_TASK", new String[0]));
        }
        if (!StringUtils.isEmpty(name)) {
            sb.append(")");
        }
        return sb.toString();
    }
}

