/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnCommentBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;

public class CoreBpmnRuntimeWithdrawProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List<CoreBpmnCommentBean> commentList = this.getBpmnCommentList(sourceList);
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource source = sourceList.get(i);
            SinoConcurrentLocker.isolated(source.getTargetId());
            CoreBpmnCommentBean comment = commentList.stream().filter(c -> c.getTargetId().equals(source.getTargetId())).max((c1, c2) -> c1.getId().compareTo(c2.getId())).orElse(null);
            if (comment != null && comment.getStatus().equals(CommentStatus.SUBMIT.name())) continue;
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_STATUS_UPDATED");
        }
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List<CoreBpmnInstanceBean> instanceList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceList();
        List<Long> idList = instanceList.stream().map(ix -> ix.getId()).collect(Collectors.toList());
        List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = this.instanceService.selectInstanceCandidatorList(idList);
        List<CoreBpmnInstanceTaskBean> taskList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTaskList();
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource source = sourceList.get(i);
            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
            source.setRuntimeInitiator(instance.getInitiator());
            source.setRuntimeProcId(instance.getProcId());
            source.setCandidatorList(instanceCandidatorList.stream().filter(c -> c.getInstId().equals(instance.getId())).map(c -> c.getCandidatorId()).distinct().collect(Collectors.toList()));
            List instanceTaskList = taskList.stream().filter(t -> {
                boolean flag = t.getInstId().equals(instance.getId());
                if (flag && !StringUtils.isEmpty(source.getCurrentStatusCode())) {
                    flag = source.getCurrentStatusCode().equals(t.getStatusCode());
                }
                return flag;
            }).collect(Collectors.toList());
            Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
            StringBuilder sb = new StringBuilder();
            for (CoreBpmnInstanceTaskBean instanceTask : instanceTaskList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                Element taskElement = BpmnDiagramHelper.getProcessElement(diagram, instanceTask.getTaskId());
                sb.append(XmlUtils.getAttributeValue(taskElement, "name"));
            }
            source.setRuntimeTaskName(sb.toString());
            if (StringUtils.isEmpty(source.getComment())) {
                source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.WITHDRAW", new String[0]));
            }
            String sourceName = sb.toString();
            String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.START", new String[0]);
            this.insertComment(source.getTargetId(), null, CommentStatus.WITHDRAW, source, this.getRoute(sourceName, targetName));
            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO<ID>();
            instanceStatus.setId(source.getId());
            instanceStatus.setProcessStatus(ProcessStatus.DRAFT_WITHDRAWED);
            instanceStatusList.add(instanceStatus);
            BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(source.getTargetId());
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
        }
        return instanceStatusList;
    }

    private List<CoreBpmnCommentBean> getBpmnCommentList(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List targetIdList = sourceList.stream().map(CoreBpmnRuntimeSource::getTargetId).collect(Collectors.toList());
        return this.commentService.getDao().selectListByOneColumnValues(targetIdList, "TARGETID", new Order[0]);
    }
}

