/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;

public class CoreBpmnRuntimeUndoProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource<T, ID> source = sourceList.get(i);
            SinoConcurrentLocker.isolated(source.getTargetId());
            if (!StringUtils.startsWithIgnoreCase(source.getOldItem().getProcessStatus(), ProcessStatus.DONE.name())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_STATUS_UPDATED");
            }
            if (StringUtils.isEmpty(source.getComment())) {
                source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.UNDO", new String[0]));
            }
            String sourceName = I18nHelper.getMessage("SINO.BPMN.TASK.END", new String[0]);
            String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.START", new String[0]);
            this.insertComment(source.getTargetId(), null, CommentStatus.UNDO, source, this.getRoute(sourceName, targetName));
            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO<ID>();
            instanceStatus.setId(source.getId());
            instanceStatus.setProcessStatus(ProcessStatus.DRAFT_UNDO);
            instanceStatusList.add(instanceStatus);
        }
        return instanceStatusList;
    }
}

