/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskUserBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import org.dom4j.Element;

public class CoreBpmnRuntimeTransferProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        List<CoreBpmnInstanceCandidatorDTO> instanceCandidatorList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceCandidatorList();
        for (CoreBpmnRuntimeSource<T, ID> source : sourceList) {
            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
            source.setRuntimeInitiator(instance.getInitiator());
            source.setRuntimeProcId(instance.getProcId());
            CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            if (!BpmnDiagramHelper.isTransferTask(taskElement)) continue;
            String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
            List candidatorList = instanceCandidatorList.stream().filter(c -> instanceTask.getId().equals(c.getInstTaskId()) && LocalContextHelper.getLoginUserId().equals(c.getCandidatorId())).collect(Collectors.toList());
            List<Long> taskUserIdList = candidatorList.stream().filter(c -> c.getTaskUserId() != null).map(c -> c.getTaskUserId()).collect(Collectors.toList());
            List<Long> taskRoleIdList = candidatorList.stream().filter(c -> c.getTaskRoleId() != null).map(c -> c.getTaskRoleId()).collect(Collectors.toList());
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskRoleId(taskRoleIdList);
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskUserId(taskUserIdList);
            CoreBpmnInstanceTaskUserBean taskUser = new CoreBpmnInstanceTaskUserBean();
            taskUser.setId(ApplicationContextHelper.getNextIdentity());
            taskUser.setInstId(instance.getId());
            taskUser.setInstTaskId(instanceTask.getId());
            taskUser.setUserId(source.getTransferCandidator());
            BpmnRuntimeCacheProvider.getProcessData().addInsertInstanceTaskUser(Arrays.asList(taskUser));
            this.insertComment(instance.getTargetId(), taskElement, CommentStatus.TRANSFER, source, this.getRoute(sourceName, sourceName));
        }
        return instanceStatusList;
    }

    @Override
    protected void validateBySql() {
    }

    @Override
    protected void updateProcessStatus(String table, List<CoreBpmnInstanceStatusDTO<ID>> statusList) {
    }

    @Override
    protected void doCallback(Map<String, List<ID>> callbackMap) {
    }
}

