/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;

public class CoreBpmnRuntimeStartProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource<T, ID> source = sourceList.get(i);
            SinoConcurrentLocker.isolated(source.getTargetId());
            if (!StringUtils.startsWithIgnoreCase(source.getOldItem().getProcessStatus(), ProcessStatus.DRAFT.name())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_STATUS_UPDATED");
            }
            Element startEventElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            if (BpmnDiagramHelper.isCommentRequiredTask(startEventElement) && StringUtils.isEmpty(source.getComment())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_DRAFT.TIP.COMMENT_REQUIRED");
            }
            String passValidatorSql = BpmnDiagramHelper.getPassValidatorSql(startEventElement);
            if (!StringUtils.isBlank(passValidatorSql)) {
                this.prepareValidateSql(i + 1, passValidatorSql, source.getId());
            }
            this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.pass, startEventElement, source.getId());
        }
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        for (CoreBpmnRuntimeSource<T, ID> source : sourceList) {
            CoreBpmnProcBean proc = BpmnRuntimeCacheProvider.getBpmnProc(source);
            CoreBpmnInstanceBean instance = new CoreBpmnInstanceBean();
            instance.setId(ApplicationContextHelper.getNextIdentity());
            instance.setTargetId(source.getTargetId());
            instance.setProcId(proc.getId());
            instance.setInitiator(LocalContextHelper.getLoginUserId());
            instance.setDiagramId(proc.getDiagramId());
            BpmnRuntimeCacheProvider.getProcessData().addInsertInstance(instance);
            source.setRuntimeInitiator(instance.getInitiator());
            source.setRuntimeProcId(instance.getProcId());
            Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
            Element startEventElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            Pair<ProcessStatus, String> result = this.completeTask(diagram, instance, startEventElement, source);
            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO<ID>();
            instanceStatus.setId(source.getId());
            instanceStatus.setProcessStatus(result.getFirst());
            instanceStatus.setStatusCode(BpmnDiagramHelper.getUserTaskStatusCode(startEventElement));
            if (!ProcessStatus.DONE.equals((Object)result.getFirst())) {
                instanceStatus.setNextStatusCode(result.getSecond());
            }
            instanceStatusList.add(instanceStatus);
            if (StringUtils.isEmpty(source.getComment())) {
                source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.SUBMIT", new String[0]));
            }
            String sourceName = I18nHelper.getMessage("SINO.BPMN.TASK.START", new String[0]);
            String targetName = instanceStatus.getNextStatusCode() == null ? I18nHelper.getMessage("SINO.BPMN.TASK.END", new String[0]) : this.getElementName(diagram, instanceStatus.getNextStatusCode());
            this.insertComment(instance.getTargetId(), startEventElement, CommentStatus.SUBMIT, source, this.getRoute(sourceName, targetName));
            BpmnRuntimeCacheProvider.getProcessData().addInsertOrUpdateBpmnTarget(this.getBpmnTarget(source, result.getFirst()));
            if (!ProcessStatus.DONE.equals((Object)result.getFirst())) continue;
            Element endEventElement = BpmnDiagramHelper.getProcessElement(diagram, ProcessElementType.END_EVENT);
            this.prepareEndCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.end, endEventElement, source.getId());
        }
        return instanceStatusList;
    }

    private Pair<ProcessStatus, String> completeTask(Document diagram, CoreBpmnInstanceBean instance, Element startEventElement, CoreBpmnRuntimeSource<T, ID> source) {
        List<Element> nextTaskElementList = BpmnRuntimeCacheProvider.getNextTask(source).getNextTaskElementList();
        if (!nextTaskElementList.isEmpty()) {
            if (nextTaskElementList.stream().anyMatch(t -> ProcessElementType.END_EVENT.equals((Object)BpmnDiagramHelper.getProcessElementType(t)))) {
                BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
                return Pair.of(ProcessStatus.DONE, null);
            }
            this.insertNextInstanceTask(diagram, instance, nextTaskElementList, source);
            String nextStatusCode = nextTaskElementList.stream().map(t -> BpmnDiagramHelper.getUserTaskStatusCode(t)).collect(Collectors.joining(","));
            return Pair.of(ProcessStatus.APPROVE, nextStatusCode);
        }
        throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
    }
}

