/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.TaskStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;

public class CoreBpmnRuntimeRejectProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        int j = sourceList.size();
        for (int i = 0; i < j; ++i) {
            CoreBpmnRuntimeSource<T, ID> source = sourceList.get(i);
            SinoConcurrentLocker.isolated(source.getTargetId());
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
            if (BpmnDiagramHelper.isCommentRequiredTask(taskElement) && StringUtils.isEmpty(source.getComment())) {
                throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_DRAFT.TIP.COMMENT_REQUIRED");
            }
            String rejectValidatorSql = BpmnDiagramHelper.getRejectValidatorSql(taskElement);
            if (!StringUtils.isBlank(rejectValidatorSql)) {
                this.prepareValidateSql(i + 1, rejectValidatorSql, source.getId());
            }
            this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.reject, taskElement, source.getId());
        }
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        List<CoreBpmnInstanceTaskHisBean> taskHisList;
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        ArrayList<CoreBpmnInstanceTaskHisBean> filterList = new ArrayList<CoreBpmnInstanceTaskHisBean>();
        Iterator<CoreBpmnRuntimeSource<T, ID>> var4 = sourceList.iterator();
        AtomicReference<CoreBpmnInstanceTaskBean> instanceTask = new AtomicReference<CoreBpmnInstanceTaskBean>();
        while (var4.hasNext()) {
            CoreBpmnRuntimeSource<T, ID> coreBpmnRuntimeSource = var4.next();
            if (StringUtils.isEmpty(coreBpmnRuntimeSource.getTargetStatusCode()) || ProcessStatus.DRAFT.name().equalsIgnoreCase(coreBpmnRuntimeSource.getTargetStatusCode())) continue;
            CoreBpmnInstanceTaskHisBean filter = new CoreBpmnInstanceTaskHisBean();
            instanceTask.set(BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(coreBpmnRuntimeSource));
            filter.setInstId(((CoreBpmnInstanceTaskBean)instanceTask.get()).getInstId());
            filter.setStatusCode(coreBpmnRuntimeSource.getTargetStatusCode());
            filterList.add(filter);
        }
        if (!filterList.isEmpty() && !(taskHisList = this.taskHisService.selectLatestTaskHisList(filterList)).isEmpty()) {
            HashMap taskHisMap = new HashMap();
            for (CoreBpmnInstanceTaskHisBean taskHis : taskHisList) {
                CoreBpmnRuntimeSource coreBpmnRuntimeSource = sourceList.stream().filter(s -> {
                    if (!s.getTargetStatusCode().equals(taskHis.getStatusCode())) {
                        return false;
                    }
                    instanceTask.set(BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(s));
                    return taskHis.getInstId().equals(((CoreBpmnInstanceTaskBean)instanceTask.get()).getInstId());
                }).findAny().orElse(null);
                if (coreBpmnRuntimeSource == null) continue;
                taskHisMap.put(coreBpmnRuntimeSource.getId(), taskHis);
            }
            BpmnRuntimeCacheProvider.cacheBpmnRuntimeTaskHisMap(taskHisMap);
        }
        for (CoreBpmnRuntimeSource<T, ID> coreBpmnRuntimeSource : sourceList) {
            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(coreBpmnRuntimeSource);
            coreBpmnRuntimeSource.setRuntimeInitiator(instance.getInitiator());
            coreBpmnRuntimeSource.setRuntimeProcId(instance.getProcId());
            instanceTask.set(BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(coreBpmnRuntimeSource));
            Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(coreBpmnRuntimeSource);
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(coreBpmnRuntimeSource);
            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO<ID>();
            if (!StringUtils.isEmpty(coreBpmnRuntimeSource.getTargetStatusCode()) && !ProcessStatus.DRAFT.name().equalsIgnoreCase(coreBpmnRuntimeSource.getTargetStatusCode())) {
                this.rejectTask(diagram, instance, (CoreBpmnInstanceTaskBean)instanceTask.get(), BpmnRuntimeCacheProvider.getBpmnRuntimeUnlimitedInstanceTaskList(), coreBpmnRuntimeSource);
                instanceStatus.setId(coreBpmnRuntimeSource.getId());
                instanceStatus.setProcessStatus(ProcessStatus.APPROVE_REJECTED);
                instanceStatus.setStatusCode(((CoreBpmnInstanceTaskBean)instanceTask.get()).getStatusCode());
                instanceStatus.setNextStatusCode(coreBpmnRuntimeSource.getTargetStatusCode());
                instanceStatusList.add(instanceStatus);
                BpmnRuntimeCacheProvider.getProcessData().addUpdateProcessStatusBpmnTarget(this.getBpmnTarget(coreBpmnRuntimeSource, ProcessStatus.APPROVE_REJECTED));
            } else {
                BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
                instanceStatus.setId(coreBpmnRuntimeSource.getId());
                instanceStatus.setProcessStatus(ProcessStatus.DRAFT_REJECTED);
                instanceStatus.setStatusCode(((CoreBpmnInstanceTaskBean)instanceTask.get()).getStatusCode());
                instanceStatusList.add(instanceStatus);
                BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(coreBpmnRuntimeSource.getTargetId());
            }
            if (StringUtils.isEmpty(coreBpmnRuntimeSource.getComment())) {
                coreBpmnRuntimeSource.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.REJECT", new String[0]));
            }
            String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
            String targetName = instanceStatus.getNextStatusCode() == null ? I18nHelper.getMessage("SINO.BPMN.TASK.START", new String[0]) : XmlUtils.getAttributeValue(BpmnDiagramHelper.getProcessElementByStatusCode(diagram, instanceStatus.getNextStatusCode()), "name");
            this.insertComment(instance.getTargetId(), taskElement, CommentStatus.REJECT, coreBpmnRuntimeSource, this.getRoute(sourceName, targetName));
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(((CoreBpmnInstanceTaskBean)instanceTask.get()).getId());
        }
        return instanceStatusList;
    }

    private void rejectTask(Document diagram, CoreBpmnInstanceBean instance, CoreBpmnInstanceTaskBean task, List<CoreBpmnInstanceTaskBean> instanceTaskUnlimitedList, CoreBpmnRuntimeSource<T, ID> source) {
        CoreBpmnInstanceTaskBean instanceTask = new CoreBpmnInstanceTaskBean();
        instanceTask.setId(task.getId());
        instanceTask.setStatus(TaskStatus.REJECTED.name());
        BpmnRuntimeCacheProvider.getProcessData().addUpdateInstanceTaskStatus(instanceTask);
        BpmnRuntimeCacheProvider.getProcessData().addDeleteCandidatorInstanceTaskId(task.getId());
        for (CoreBpmnInstanceTaskBean instanceTaskUnlimited : instanceTaskUnlimitedList) {
            if (task.getId().equals(instanceTaskUnlimited.getId())) continue;
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(instanceTaskUnlimited.getId());
        }
        Element targetElement = BpmnDiagramHelper.getProcessElementByStatusCode(diagram, source.getTargetStatusCode());
        this.insertNextInstanceTask(diagram, instance, Arrays.asList(targetElement), source);
    }
}

