/*
 * Decompiled with CFR 0.152.
 */
package net.sinodawn.module.sys.bpmn.engine.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.support.AbstractCoreBpmnRuntimeProcessSupport;
import org.dom4j.Element;

public class CoreBpmnRuntimeOddRejectProcessSupport<T extends Auditable<ID>, ID extends Serializable>
extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
    @Override
    protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
    }

    @Override
    protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
        sourceList.forEach(s -> s.setRuntimeCheckPermission(false));
        ArrayList<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList<CoreBpmnInstanceStatusDTO<ID>>();
        for (CoreBpmnRuntimeSource<CoreBpmnRuntimeSource, ID> coreBpmnRuntimeSource : sourceList) {
            SinoConcurrentLocker.isolated(coreBpmnRuntimeSource.getTargetId());
            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(coreBpmnRuntimeSource);
            coreBpmnRuntimeSource.setRuntimeInitiator(instance.getInitiator());
            coreBpmnRuntimeSource.setRuntimeProcId(instance.getProcId());
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
            CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(coreBpmnRuntimeSource);
            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(coreBpmnRuntimeSource);
            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO<ID>();
            instanceStatus.setId(coreBpmnRuntimeSource.getId());
            instanceStatus.setProcessStatus(ProcessStatus.DRAFT_REJECTED);
            instanceStatusList.add(instanceStatus);
            BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(coreBpmnRuntimeSource.getTargetId());
            if (StringUtils.isEmpty(coreBpmnRuntimeSource.getComment())) {
                coreBpmnRuntimeSource.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.REJECT", new String[0]));
            }
            String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
            String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.START", new String[0]);
            this.insertComment(instance.getTargetId(), null, CommentStatus.REJECT, coreBpmnRuntimeSource, this.getRoute(sourceName, targetName));
            this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.reject, taskElement, coreBpmnRuntimeSource.getId());
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(instanceTask.getId());
        }
        return instanceStatusList;
    }
}

